/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.core;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.backend.ProjectGenerationContext;
import com.freescale.s32ds.cross.wizard.backend.WizardBackend;
import com.nxp.s32ds.cle.cdt.internal.core.Activator;
import com.nxp.s32ds.cle.cdt.internal.core.CommandLineException;
import com.nxp.s32ds.cle.cdt.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.internal.core.parser.CommandLineInputHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.load.SdksLoader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.xml.sax.SAXException;

public class DSCmdApplication
implements IApplication {
    private static final String NEW_PROJECT_FILE = "-newProjectFile";
    private GeneralContext generalContext;
    private ProjectContext projectContext;
    private CommandLineInputHandler handler;

    public Object start(IApplicationContext context) throws Exception {
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_start_first_line));
        try {
            this.parseInputArgs((String[])context.getArguments().get("application.args"));
            this.initCMDLineApp();
            this.createProjectFromCommandLine();
        }
        catch (Exception e) {
            Activator.getBundle().logError(e.getMessage());
            throw e;
        }
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_start_last_line));
        return IApplication.EXIT_OK;
    }

    public void stop() {
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_stop_called));
    }

    private void parseInputArgs(String[] args) throws CommandLineException, ParserConfigurationException, SAXException, IOException {
        int i = 0;
        while (i < args.length) {
            if (NEW_PROJECT_FILE.equals(args[i])) {
                if (i + 1 == args.length) {
                    throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_argument_should_be_followed_by_a_valid_xml_file, (Object)NEW_PROJECT_FILE));
                }
                this.handler = CommandLineInputHandler.parseInputFile(args[i + 1]);
            }
            ++i;
        }
        if (this.handler == null) {
            throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_check_arguments_order, (Object)NEW_PROJECT_FILE));
        }
    }

    private void createProjectFromCommandLine() throws CommandLineException {
        this.updateContext();
        ProjectGenerationContext projectGenerationContext = ProjectGenerationContext.start((GeneralContext)this.generalContext, (ProjectContext)this.projectContext);
        WizardBackend wb = new WizardBackend();
        wb.setCurrentContext(this.generalContext);
        wb.wrapCreateProject(projectGenerationContext, true, this.handler.getSdkPath());
    }

    private void updateContext() throws CommandLineException {
        HWModel archModel = Hardware.instance().getModel(this.handler.getArchId());
        if (archModel == null) {
            throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_the_tag_defined_in_the_input_file_is_not_valid, (Object)"arch", (Object)this.handler.getArchId()));
        }
        ProcessorData processorData = archModel.getCores().stream().filter(e -> e.getId().equals(this.handler.getCoreId())).map(ConfigurationData::getParent).filter(Objects::nonNull).map(ConfigurationData::getParent).filter(Objects::nonNull).filter(ProcessorData.class::isInstance).map(d -> (ProcessorData)d).findFirst().orElse(null);
        if (processorData == null) {
            throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_the_tag_defined_in_the_input_file_is_not_valid, (Object)"core", (Object)this.handler.getArchId()));
        }
        List cConf = CoreNatureConfiguration.getDefaults((ProcessorData)processorData, (boolean)this.handler.isExec(), (String)this.handler.getToolchain());
        this.generalContext = new GeneralContext(archModel);
        this.generalContext.setCurrentProcessorConfiguration(new ProcessorConfiguration(processorData, (Collection)cConf, this.handler.isExec()));
        this.generalContext.setProjectBaseName(this.handler.getProjectName());
        this.generalContext.setExecutable(this.handler.isExec());
        DSCmdApplication.setValues(this.handler.getGlobalSettings(), (AbstractContext)this.generalContext);
        this.projectContext = this.getDefaultProjectContext();
        DSCmdApplication.setValues(this.handler.getProjectSettings(), (AbstractContext)this.projectContext);
    }

    private void initCMDLineApp() throws CommandLineException, InterruptedException {
        int ret = PlatformUI.createAndRunWorkbench((Display)PlatformUI.createDisplay(), (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return "no.ui.perspective";
            }

            public void eventLoopIdle(Display display) {
                PlatformUI.getWorkbench().close();
            }

            public boolean openWindows() {
                return true;
            }
        });
        if (ret != 0) {
            throw new CommandLineException(Messages.DSCmdApplication_error_occured_when_starting_the_workbench);
        }
        SdksLoader.sdkLoaderSemaphore.acquire();
    }

    private ProjectContext getDefaultProjectContext() throws CommandLineException {
        ProjectContext localProjectContext;
        ProcessorContext currentContext = this.generalContext.getCurrentContext();
        if (currentContext == null) {
            throw new CommandLineException(Messages.DSCmdApplication_no_processor_defined_for_the_current_input);
        }
        List contextsList = currentContext.getActiveProjectContexts();
        ProjectContext projectContext = localProjectContext = contextsList.isEmpty() ? null : (ProjectContext)contextsList.get(0);
        if (localProjectContext == null) {
            throw new CommandLineException(Messages.DSCmdApplication_no_processor_defined_for_the_current_input);
        }
        return localProjectContext;
    }

    private static void setValues(Map<String, String> input, AbstractContext context) {
        for (Map.Entry<String, String> entry : input.entrySet()) {
            context.setValue(entry.getKey(), (Object)entry.getValue());
        }
    }
}

