/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DefaultErrorHandler
implements FreqLimitErrorI {
    private static final Logger LOGGER = LogManager.getLogger(DefaultErrorHandler.class);
    @NonNull
    private IMcu mcu;
    @NonNull
    private IClocksConfig config;
    @NonNull
    @NonNull Map<@NonNull String, @NonNull String> errors = new HashMap<String, String>();

    public DefaultErrorHandler(@NonNull IMcu mcu, @NonNull IClocksConfig config) {
        this.mcu = mcu;
        this.config = config;
    }

    public void logFreqLimitError(boolean isOnInput, @NonNull Node device) {
        IClockElement element = this.mcu.getClockElement(device.getID());
        if (element != null) {
            element.addFrequencyError(isOnInput, this.errors, device, this.config);
        } else {
            LOGGER.warning("Error logged for element " + device.getID() + " but the element does not exist");
        }
    }

    public void logDividerError(EDividerError error, @NonNull Node device) {
        IClockElement element = this.mcu.getClockElement(device.getID());
        if (element != null) {
            element.addDivisionError(error, this.errors, this.mcu, device, this.config);
        } else {
            LOGGER.warning("Error logged for element " + device.getID() + " but the element does not exist");
        }
    }

    public @NonNull Map<@NonNull String, @NonNull String> getErrors() {
        return CollectionsUtils.unmodifiableMap(this.errors);
    }
}

