/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.clocks.data.model.EmptyMcu;
import com.nxp.swtools.clocks.data.parser.McuParser;
import com.nxp.swtools.clocks.data.parser.ParserException;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.resources.DataDirectory;
import com.nxp.swtools.clocks.resources.ProcessorFilterForClocksTool;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedToolsByProcessor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class McuDB {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(McuDB.class);
    @NonNull
    private static final McuDB INSTANCE = new McuDB();
    @NonNull
    private @NonNull Map<@NonNull IMcuDescriptor, SoftReference<IMcu>> mcuDatabase = new ConcurrentHashMap<IMcuDescriptor, SoftReference<IMcu>>();

    public @NonNull IMcu getMcu(@NonNull IMcuDescriptor descriptor) {
        SoftReference<IMcu> softReference = this.mcuDatabase.get(descriptor);
        IMcu cachedMcu = null;
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(descriptor.getID(), descriptor.getSDKVersion());
        if (softReference != null) {
            cachedMcu = softReference.get();
        }
        if (!SWToolsProperties.isVerificationOn() && cachedMcu != null) {
            return cachedMcu;
        }
        if (!ProcessorFilterForClocksTool.isSupported(descriptor)) {
            if (info == null || !SupportedToolsByProcessor.isToolDisabled((IProcessorMasterToolInfo)info, (String)"Clocks")) {
                LOGGER.info("Using default (empty) MCU, as requested one is not supported. Missing requirements: " + ProcessorFilterForClocksTool.getMissingRequirements(descriptor));
            }
            return new EmptyMcu(UtilsText.safeString((String)Messages.get().ClocksProfile_McuNotSupported));
        }
        IMcu mcu = null;
        String filePath = String.valueOf(DataDirectory.getDataDir()) + File.separator + DataDirectory.getMcuRelFile(descriptor);
        File file = new File(filePath);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedInputStream is = new BufferedInputStream(UtilsDecryption.getFileInputStream((File)file));){
                mcu = McuParser.parse(is, descriptor, filePath);
                this.mcuDatabase.put(descriptor, new SoftReference<IMcu>(mcu));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParserException | IOException | SecurityException e) {
            LOGGER.log(Level.SEVERE, "Error while processing '" + filePath + "' for MCU: " + descriptor.getID() + ". Empty MCU will be used instead.", e);
            mcu = new EmptyMcu(UtilsText.safeString((String)Messages.get().McuDB_EmpyMCUBecauseOfParsingError));
        }
        return mcu;
    }

    public void removeMcu(@NonNull IMcuDescriptor descriptor) {
        this.mcuDatabase.remove(descriptor);
    }

    public static @NonNull McuDB getInstance() {
        return INSTANCE;
    }
}

