/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import java.util.Objects;

public class McuDescriptor
implements IMcuDescriptor {
    @NonNull
    private String id;
    @NonNull
    private String family;
    @NonNull
    private String series;
    @NonNull
    private String version;
    @NonNull
    private String partNumVersion;
    @NonNull
    private String sdkVersion;
    @Nullable
    private String mexVariant;

    public McuDescriptor(@NonNull String family, @NonNull String series, @NonNull String id, @NonNull String version, @NonNull String partNumVer, @NonNull String sdkVersion, @Nullable String mexVariant) {
        this.family = family;
        this.series = series;
        this.id = id;
        this.version = version;
        this.partNumVersion = partNumVer;
        this.sdkVersion = sdkVersion;
        this.mexVariant = mexVariant;
    }

    public static @Nullable McuDescriptor fromSharedConfig(@NonNull ICommonConfig mcuSelection) {
        String sdk;
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        McuDescriptor descriptor = null;
        String mcuStr = UtilsText.safeString((String)mcuSelection.getMcu());
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcuStr, sdk = UtilsText.safeString((String)mcuSelection.getSdkVersion()));
        if (info != null) {
            String partNumber = mcuSelection.getPackage();
            descriptor = new McuDescriptor(info.getFamily(), info.getSeries(), info.getId(), info.getVersion(), partNumber, sdk, mcuSelection.getMexVariant());
        }
        return descriptor;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public String getSeries() {
        return this.series;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getPartNumber() {
        return this.partNumVersion;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.family.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.series.hashCode();
        result = 31 * result + this.partNumVersion.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.sdkVersion.hashCode();
        result = 31 * result + Objects.hash(this.mexVariant);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        McuDescriptor other = (McuDescriptor)obj;
        if (!this.family.equals(other.family)) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.series.equals(other.series)) {
            return false;
        }
        if (!this.version.equals(other.version)) {
            return false;
        }
        if (!this.partNumVersion.equals(other.partNumVersion)) {
            return false;
        }
        if (!this.sdkVersion.equals(other.sdkVersion)) {
            return false;
        }
        return Objects.equals(this.mexVariant, other.mexVariant);
    }

    @Override
    public @NonNull String getVersion() {
        return this.version;
    }

    @Override
    public @NonNull String getSDKVersion() {
        return this.sdkVersion;
    }

    @Override
    public @Nullable String getMexVariant() {
        return this.mexVariant;
    }
}

