/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.dependencies;

import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.LocalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.graphs.DirectedGraph;
import com.nxp.swtools.common.utils.graphs.IEditableDirectedGraph;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;

public class SettingDependencyGraph
extends DirectedGraph {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SettingDependencyGraph.class);
    @NonNull
    private final SettingsDB settingsDB;
    protected final Map<@NonNull String, Collection<@NonNull String>> sharedBitFieldsMap;

    public SettingDependencyGraph(@NonNull SettingsDB settingsDB) {
        this.settingsDB = settingsDB;
        this.sharedBitFieldsMap = new HashMap<String, Collection<String>>();
    }

    public SettingDependencyGraph(@NonNull Collection<@NonNull String> roots, @NonNull Map<@NonNull String, @Nullable Collection<@NonNull String>> successorsMap, @NonNull SettingsDB settingsDB) {
        this.settingsDB = settingsDB;
        successorsMap.forEach((x, y) -> {
            if (y == null) {
                this.successorsMap.put(x, y);
            } else {
                this.successorsMap.put(x, new HashSet(y));
            }
        });
        this.fillPredecessorsFromSuccessors();
        this.sharedBitFieldsMap = new HashMap<String, Collection<String>>();
        this.roots.addAll(roots);
    }

    public void verifyBitFieldSettings() {
        for (String node : this.findIndependentNodes()) {
            ISetting setting = this.settingsDB.findSettingWithId(node);
            if (setting == null || setting.getType() != SettingType.BIT_FIELD) continue;
            LOGGER.warning(String.valueOf(node) + " setting can not be changed in tool!");
        }
    }

    public void refreshSharedBitFields() {
        this.predecessorsMap.forEach((node, predecessors) -> {
            boolean isShared;
            ISetting setting;
            if (predecessors.size() > 1 && (setting = this.settingsDB.findSettingWithId((String)node)) != null && setting.getType() == SettingType.BIT_FIELD && (isShared = predecessors.stream().allMatch(predecessor -> {
                ISetting predecessorSetting = this.settingsDB.findSettingWithId((String)predecessor);
                if (predecessorSetting instanceof LocalConfigElementSetting) {
                    return !((LocalConfigElementSetting)predecessorSetting).getConfigElement().getItemsMaskedBitFields().isEmpty();
                }
                return false;
            }))) {
                this.sharedBitFieldsMap.put((String)node, (Collection<String>)predecessors);
            }
        });
    }

    public @NonNull IEditableDirectedGraph createEditableCopy() {
        return new SettingDependencyGraph(this.roots, this.successorsMap, this.settingsDB);
    }

    protected @NonNull String getRootStyle(@NonNull String node) {
        if (this.settingsDB.findSettingWithId(node) instanceof BitFieldSetting) {
            return "[style=filled,color=grey,shape=rectangle]";
        }
        return "[style=filled,color=grey]";
    }

    protected @NonNull String getNonRootStyle(@NonNull String node) {
        if (this.settingsDB.findSettingWithId(node) instanceof BitFieldSetting) {
            return "[shape=rectangle]";
        }
        return "";
    }

    protected @NonNull String getEdgeStyle(@NonNull String from, @NonNull String to) {
        if (this.settingsDB.findSettingWithId(to) instanceof BitFieldSetting) {
            return "[color=green]";
        }
        return "";
    }

    public Map<@NonNull String, Collection<@NonNull String>> getSharedBitFieldNodes() {
        return this.sharedBitFieldsMap;
    }
}

