/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IGenericProblem;
import com.nxp.swtools.validation.engine.IProblemOpenHandler;
import java.util.regex.Pattern;

public class ClocksProblem
implements IGenericProblem,
IProblemOpenHandler {
    private final int level;
    @NonNull
    private final String message;
    @NonNull
    private final String resource;
    @NonNull
    private final IClocksConfig config;
    @NonNull
    private final String tooltip;
    @NonNull
    private final Type problemType;
    private static final Pattern SEE_CONSTRAINT_PATTERN = Pattern.compile("\\ \\(See\\ constraint\\ \\d+\\)");

    public ClocksProblem(@NonNull IClocksConfig config, @NonNull String source, @NonNull String message, int level, @NonNull Type problemType, @NonNull String tooltip) {
        this.level = level;
        this.message = SEE_CONSTRAINT_PATTERN.matcher(message).replaceAll("");
        this.resource = source;
        this.config = config;
        this.problemType = problemType;
        this.tooltip = tooltip;
    }

    public String getToolId() {
        return "Clocks";
    }

    public int getProblemLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSource() {
        return "Clocks: " + this.config.getName();
    }

    public @NonNull String getResource() {
        return this.resource;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Type getProblemType() {
        return this.problemType;
    }

    public @NonNull ClocksProblem clone(@NonNull IClocksConfig newConfig) {
        return new ClocksProblem(newConfig, this.resource, this.message, this.level, this.problemType, this.tooltip);
    }

    public @NonNull IClocksConfig getConfig() {
        return this.config;
    }

    public void openProblem(@NonNull IBaseProblem problem) {
        this.openTool("Clocks");
        GuiController.getInstance().getProfile().setActiveConfig(this.getConfig());
        GuiController.getInstance().fireListeners(new ToolEvent.Builder(32).setOriginator((Object)this).build());
        PerspectivesHelper.showView((String)"com.nxp.swtools.clocks.DiagramView");
        IClockElement el = UiController.getInstance().getClockElementById(this.resource);
        GuiController.getInstance().setSelectedElement(el == null ? this.resource : el.getID(), this);
    }

    public @Nullable String getTargetToolId() {
        return this.getToolId();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.config.getName().hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.resource.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClocksProblem other = (ClocksProblem)obj;
        if (!this.config.getName().equals(other.config.getName())) {
            return false;
        }
        if (!this.resource.equals(other.resource)) {
            return false;
        }
        return this.message.equals(other.message);
    }

    public String toString() {
        return "ClocksProblem [resource=" + this.resource + ", config=" + this.config + "]";
    }

    public static enum Type {
        GLOBAL,
        LOCAL,
        SETTING,
        REQUIREMENT,
        OTHER;

    }
}

