/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.parser;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.logging.Logger;

public class ClockSignalInterface {
    @NonNull
    private String id;
    @NonNull
    private String name;
    private boolean isOutput;
    private boolean available;
    private boolean isTopOutput;
    @Nullable
    private String description;
    @NonNull
    private String group;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ClockSignalInterface.class);

    public ClockSignalInterface(@NonNull String id, @NonNull String name, boolean isOutput, boolean isTopOutput, boolean available, @Nullable String group, @Nullable String description) {
        this.id = id;
        this.name = name;
        this.isOutput = isOutput;
        this.isTopOutput = isTopOutput;
        this.available = available;
        if (group == null || group.isEmpty()) {
            this.group = "peripheral";
            if (isOutput && isTopOutput) {
                LOGGER.warning(String.valueOf(id) + ": missing output group type. Peripheral will be used instead.");
            }
        } else {
            this.group = group;
        }
        this.description = description;
    }

    public @NonNull String getId() {
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public boolean isOutput() {
        return this.isOutput;
    }

    public boolean isTopOutput() {
        return this.isTopOutput;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public @NonNull String getGroup() {
        return this.group;
    }
}

