/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.AGeneralSetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import com.nxp.swtools.utils.registers.BitFieldInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BitFieldSetting
extends AGeneralSetting {
    @NonNull
    public static final String BIT_FIELD_SUF = "bitField";
    @NonNull
    private BitFieldElement bitField;
    public static final int TWO = 2;

    public BitFieldSetting(@NonNull BitFieldElement bitField) {
        super(bitField.getBitField().getDescription(), SettingType.BIT_FIELD, bitField);
        this.bitField = bitField;
        this.editable = true;
        this.editableByDefault = true;
        this.enabled = true;
        this.visible = true;
    }

    @Override
    public boolean shouldBeSaved(@NonNull IClocksConfig currentConfig) {
        return false;
    }

    @Override
    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        List<@NonNull SettingValue> values = this.getValues(clocksConfig);
        if (values != null) {
            for (SettingValue value : values) {
                if (!uiValue.equals(value.getUiValue())) continue;
                return value;
            }
        }
        return SettingValue.N_A;
    }

    @Override
    public @Nullable SettingValue parseBfValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        return BitFieldSetting.parseBfValue(value, this.bitField.getBitField());
    }

    public static @Nullable SettingValue parseBfValue(@NonNull Object value, @NonNull IRegBitFieldAPI bitFieldApi) {
        BigRational rationalValue;
        Range range;
        List<@NonNull SettingValue> values = BitFieldSetting.getValues(bitFieldApi);
        if (values != null) {
            for (SettingValue settingValue : values) {
                if (!settingValue.getValue().equals(value)) continue;
                return settingValue;
            }
        }
        if (value instanceof Number && (range = BitFieldSetting.getRangeOfValues(bitFieldApi)).isInRange(rationalValue = BigRational.parse((String)UtilsText.safeString((String)value.toString())))) {
            return new SettingValue(value);
        }
        return null;
    }

    @Override
    protected @NonNull String getIdSuffix() {
        return BIT_FIELD_SUF;
    }

    @Override
    public @NonNull String getId() {
        return BitFieldSetting.createId(this.bitField);
    }

    public static @NonNull String createId(BitFieldElement bitField) {
        return String.valueOf(bitField.getId()) + "." + BIT_FIELD_SUF;
    }

    @Override
    public @NonNull SettingType getType() {
        return SettingType.BIT_FIELD;
    }

    @Override
    public @Nullable SettingValue parseValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        return this.parseBfValue(value, clocksConfig);
    }

    @Override
    public @Nullable List<@NonNull SettingValue> getValues(@NonNull IClocksConfig clocksConfig) {
        return BitFieldSetting.getValues(this.bitField.getBitField());
    }

    public static @Nullable List<@NonNull SettingValue> getValues(@NonNull IRegBitFieldAPI bitFieldApi) {
        ArrayList<@NonNull SettingValue> settingValues = new ArrayList<SettingValue>();
        IRegBitFieldValueAPI @NonNull [] bitFieldValues = bitFieldApi.getValues();
        if (bitFieldValues.length != 0) {
            IRegBitFieldValueAPI[] iRegBitFieldValueAPIArray = bitFieldValues;
            int n = bitFieldValues.length;
            int n2 = 0;
            while (n2 < n) {
                IRegBitFieldValueAPI bitFieldValue = iRegBitFieldValueAPIArray[n2];
                long valueCount = bitFieldValue.numberOfValues();
                if (valueCount > Integer.MAX_VALUE) {
                    LOGGER.severe("Number of values was too big to be generated for " + bitFieldApi.getName() + " bit-field setting");
                    return null;
                }
                long i = 0L;
                while (i < valueCount) {
                    Long longValue = (Long)bitFieldValue.getValues(0L, 1).get(0);
                    settingValues.add(new SettingValue(longValue));
                    ++i;
                }
                ++n2;
            }
        } else {
            return null;
        }
        return settingValues;
    }

    public static @Nullable SettingValue createValue(@NonNull BitFieldInfo bitFieldInfo) {
        BigInteger value = bitFieldInfo.getValue();
        if (value != null) {
            return BitFieldSetting.parseBfValue(value.longValue(), bitFieldInfo.getBitFieldAPI());
        }
        return null;
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        IRegBitFieldValueAPI bfValue = ClocksBitFieldProvider.getBitFieldValueOrResetValue(this.bitField, config);
        Long longValue = bfValue.getValue();
        return new SettingValue(longValue);
    }

    public @NonNull BitFieldElement getBitField() {
        return this.bitField;
    }

    @Override
    public @Nullable SettingValue getDefaultValue(IClocksConfig clockConfig) {
        Long longValue = this.bitField.getResetValue().longValue();
        assert (longValue != null);
        return new SettingValue(longValue);
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig clocksConfig) {
        return true;
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return true;
    }

    @Override
    public @NonNull String toString(@NonNull SettingValue settingValue) {
        return settingValue.getUiValue();
    }

    @Override
    public @Nullable SettingValue fromString(@NonNull String string, @NonNull IClocksConfig clocksConfig) {
        return this.parseUiValue(string, clocksConfig);
    }

    @Override
    public boolean isUserLockable() {
        return true;
    }

    @Override
    public @NonNull Range getRangeOfValues(@NonNull IClocksConfig config) {
        return BitFieldSetting.getRangeOfValues(this.bitField.getBitField());
    }

    public static @NonNull Range getRangeOfValues(@NonNull IRegBitFieldAPI bitFieldApi) {
        long maxVal = (long)Math.pow(2.0, bitFieldApi.getWidth()) - 1L;
        return new Range(0L, maxVal);
    }
}

