/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.AFrequencyModifierSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.model.ICalculus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class PrescalerSetting
extends AFrequencyModifierSetting {
    @NonNull
    private static final String MULTIPLY = "*";
    @NonNull
    private static final String DIVIDE = "/";
    @NonNull
    public static final String ID_SUFFIX = "scale";
    @NonNull
    private Prescaler prescaler;

    public PrescalerSetting(@NonNull Prescaler prescaler) {
        super(prescaler);
        this.prescaler = prescaler;
    }

    @Override
    public List<SettingValue> getValues(IClocksConfig clocksConfig) {
        List<@NonNull SettingValue> values = null;
        List<@NonNull String> scaleValues = this.prescaler.getUiScaleValues(clocksConfig);
        if (scaleValues.size() <= 256 && !scaleValues.isEmpty()) {
            values = this.getScaleValues(clocksConfig, scaleValues);
        }
        return values;
    }

    protected @NonNull List<@NonNull SettingValue> getScaleValues(@NonNull IClocksConfig clocksConfig, @NonNull List<@NonNull String> scaleValues) {
        ValueMap activeMap = this.prescaler.getActiveValueMap(clocksConfig);
        ArrayList<@NonNull SettingValue> values = new ArrayList<SettingValue>();
        if (activeMap != null) {
            for (String strValue : scaleValues) {
                String uiValue = String.valueOf(this.getScalePrefix()) + " " + strValue;
                assert (strValue != null);
                Object controlValue = activeMap.getControlValueByUiValue(strValue);
                if (controlValue == null) continue;
                values.add(new SettingValue(controlValue, uiValue));
            }
        }
        return values;
    }

    @Override
    public SettingValue parseUiValue(String uiValue, IClocksConfig clocksConfig) {
        String unPrefixedUiValue = this.getUnprefixedPart(uiValue);
        ValueMap activeValueMap = this.prescaler.getActiveValueMap(clocksConfig);
        if (activeValueMap != null) {
            Constraint constraint;
            Object value = activeValueMap.getControlValueByUiValue(unPrefixedUiValue);
            if (value != null) {
                return new SettingValue(UtilsText.safeToString((Object)value), String.valueOf(this.getScalePrefix()) + " " + BigRational.parse((String)unPrefixedUiValue).toExactDecimalString(4));
            }
            ICalculus calculus = activeValueMap.getCalculus();
            if (calculus != null && (constraint = (Constraint)calculus.getProblematicConstraint()) != null && constraint.isApplicable(clocksConfig)) {
                clocksConfig.addError(this.getId(), constraint.getDescription(), ClocksProblem.Type.SETTING);
                return new SettingValue(UtilsText.safeToString((Object)unPrefixedUiValue), String.valueOf(this.getScalePrefix()) + " " + unPrefixedUiValue);
            }
        }
        return null;
    }

    private @NonNull String getUnprefixedPart(@NonNull String uiValue) {
        String trimmedScalePrefix = this.getScalePrefix();
        String trimmedUiValue = uiValue.trim();
        String unPrefixedUiValue = trimmedUiValue.startsWith(trimmedScalePrefix) ? trimmedUiValue.substring(trimmedScalePrefix.length()).trim() : trimmedUiValue;
        assert (unPrefixedUiValue != null);
        return BigRational.unlocalizeDecimals((String)unPrefixedUiValue);
    }

    @Override
    public @Nullable SettingValue findNearestUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        String unPrefixedUiValue = this.getUnprefixedPart(uiValue);
        try {
            BigRational fraction = new BigRational(this.getPrescaler().getFraction(clocksConfig));
            BigRational contrValue = new BigRational(new BigDecimal(unPrefixedUiValue)).multiply(fraction);
            assert (contrValue != null);
            BigRational rationalContrValue = new BigRational(contrValue);
            BigRational nearest = null;
            Range range = this.getRangeOfValues(clocksConfig);
            if (range != null) {
                BigRational steps = rationalContrValue.subtract(range.getMin()).divide(range.getStep());
                BigInteger roundedSteps = steps.toBigIntegerRounded(true);
                steps = new BigRational(roundedSteps);
                nearest = range.getMin().add(range.getStep().multiply(steps));
                if (nearest.compareTo(BigRational.ZERO) < 0) {
                    nearest = range.getMin();
                }
            } else {
                BigRational nearestDst = null;
                List<@NonNull String> uiScaleValues = this.prescaler.getUiScaleValues(clocksConfig);
                List<@NonNull SettingValue> scaleValues = this.getScaleValues(clocksConfig, uiScaleValues);
                for (SettingValue settVal : scaleValues) {
                    BigRational contrSettValue = new BigRational(settVal.getValue().toString());
                    BigRational dist = contrValue.subtract(contrSettValue).abs();
                    if (nearestDst != null && dist.compareTo(nearestDst) >= 0) continue;
                    nearestDst = dist;
                    nearest = contrSettValue;
                }
            }
            if (nearest != null) {
                BigRational nearestUiValueDecimal = new BigRational(nearest).divide(fraction);
                return new SettingValue(nearest, String.valueOf(this.getScalePrefix()) + " " + nearestUiValueDecimal.toExactDecimalString(4));
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.WARNING, "Error while performing find nearest UI value of setting: " + this.getId() + ", requested UI value: " + uiValue, ex);
        }
        return null;
    }

    @Override
    public @Nullable SettingValue parseValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        String uiValue;
        ValueMap activeValueMap = this.prescaler.getActiveValueMap(clocksConfig);
        if (activeValueMap != null && (uiValue = activeValueMap.getUiValueByControlValue(UtilsText.safeToString((Object)value))) != null) {
            return new SettingValue(UtilsText.safeToString((Object)value), String.valueOf(this.getScalePrefix()) + " " + BigRational.parse((String)uiValue).toExactDecimalString(4));
        }
        LOGGER.warning(value + " of setting: " + this.getId() + " was not parsed properly.");
        return new SettingValue(UtilsText.safeToString((Object)value), String.valueOf(this.getScalePrefix()) + " " + UtilsText.safeToString((Object)value));
    }

    @Override
    public boolean isValid(SettingValue settingValue, IClocksConfig clocksConfig) {
        List<@NonNull SettingValue> values = this.getScaleValues(clocksConfig, this.prescaler.getUiScaleValues(clocksConfig));
        return (values.isEmpty() || values.contains(settingValue)) && this.isElementValid(clocksConfig);
    }

    @Override
    public SettingValue getDefaultValue(IClocksConfig clockConfig) {
        ValueMap activeValueMap = this.prescaler.getActiveValueMap(clockConfig);
        if (activeValueMap != null) {
            String defaultScale = activeValueMap.getDefaultUiValue();
            String uiValue = String.valueOf(this.getScalePrefix()) + " " + defaultScale;
            return this.parseUiValue(uiValue, clockConfig);
        }
        return null;
    }

    private @NonNull String getScalePrefix() {
        return this.prescaler.isDivider() ? DIVIDE : MULTIPLY;
    }

    public @NonNull Prescaler getPrescaler() {
        return this.prescaler;
    }

    @Override
    protected @NonNull String getIdSuffix() {
        return ID_SUFFIX;
    }

    @Override
    public @NonNull String toString(@NonNull SettingValue settingValue) {
        return UtilsText.safeString((String)settingValue.getValue().toString());
    }

    @Override
    public @Nullable SettingValue fromString(@NonNull String string, @NonNull IClocksConfig clocksConfig) {
        try {
            BigRational rationalValue = BigRational.tryParse((String)string);
            if (rationalValue == null) {
                rationalValue = new BigRational(string);
            }
            return this.parseValue(rationalValue.toExactDecimalString(), clocksConfig);
        }
        catch (NumberFormatException exception) {
            LOGGER.log(Level.WARNING, "Could not parse value: " + string + " of setting: " + this.getId(), exception);
            return SettingValue.N_A;
        }
    }

    @Override
    public boolean isComboSuppressionAllowed() {
        return true;
    }

    @Override
    public @Nullable Range getRangeOfValues(@NonNull IClocksConfig config) {
        Range range;
        ValueMap activeValueMap;
        if (this.element instanceof IClockElement && (activeValueMap = ((IClockElement)this.element).getActiveValueMap(config)) != null && (range = activeValueMap.getRange()) != null) {
            BigRational minScale = new BigRational(this.prescaler.getMinScale(), 1L);
            BigRational maxScale = new BigRational(this.prescaler.getMaxScale(), 1L);
            BigRational min = range.getMin().compareTo(minScale) > 0 ? range.getMin() : minScale;
            BigRational max = range.getMax().compareTo(maxScale) < 0 ? range.getMax() : maxScale;
            Range prescalerRange = new Range(min, max);
            prescalerRange.setStep(range.getStep());
            return prescalerRange;
        }
        return null;
    }

    @Override
    public @Nullable String getAllowedValueDescription(@NonNull IClocksConfig clocksConfig) {
        return "";
    }

    @Override
    public boolean isPrioritized() {
        return this.prescaler.isPrioritized();
    }
}

