/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.valueMaps.EntryValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.BitFieldVariable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AValueMapBuilder
implements IValueMapBuilder {
    protected int fractionalBits = 0;
    @NonNull
    protected @NonNull BitFieldElement @NonNull [] bitFields;
    @NonNull
    protected BitFieldsCache registers;
    @NonNull
    protected Expression expression;
    protected boolean enableDescriptions = true;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(EntryValueMap.class);
    @NonNull
    @NonNull List<@NonNull Constraint> constraint = new ArrayList<Constraint>();

    public AValueMapBuilder(@NonNull BitFieldsCache registers, @NonNull Expression expression) {
        this.registers = registers;
        this.expression = expression;
        this.bitFields = AValueMapBuilder.findBitFields(expression, registers);
    }

    protected @NonNull String createFractionalUiValue(@NonNull String uiValue) {
        BigDecimal defaultDecimal = new BigDecimal(uiValue);
        BigDecimal fractionDecimal = new BigDecimal(BigInteger.ONE.shiftLeft(this.fractionalBits));
        String fractionalUiValue = UtilsText.safeString((String)defaultDecimal.divide(fractionDecimal).toPlainString());
        return fractionalUiValue;
    }

    protected static @NonNull BitFieldElement @NonNull [] findBitFields(@NonNull Expression expression, @NonNull BitFieldsCache registers) {
        ArrayList<@NonNull BitFieldElement> foundBitfields = new ArrayList<BitFieldElement>();
        for (BitFieldVariable bfVar : expression.getBitFields()) {
            String bitFieldId = expression.getContext().getBitFieldId(bfVar.getRegisterName(), bfVar.getBitFieldName());
            BitFieldElement foundBitField = ClocksBitFieldProvider.getBitFieldById(bitFieldId, registers);
            if (foundBitField == null) {
                LOGGER.severe(String.valueOf(bfVar.getRegisterName()) + '.' + bfVar.getBitFieldName() + " not found!");
                continue;
            }
            foundBitfields.add(foundBitField);
        }
        return AValueMapBuilder.toArray(foundBitfields);
    }

    private static @NonNull BitFieldElement @NonNull [] toArray(@NonNull List<@NonNull BitFieldElement> bitfields) {
        @NonNull BitFieldElement[] array = new BitFieldElement[bitfields.size()];
        array = bitfields.toArray(array);
        assert (array != null);
        return array;
    }

    protected @Nullable IRegBitFieldValueAPI getValueFromSingleBf(@NonNull LongValues values) {
        if (this.bitFields.length != 1) {
            return null;
        }
        BitFieldElement bitField = this.bitFields[0];
        IRegBitFieldValueAPI[] bfVals = bitField.getBitField().getValues();
        if (bfVals.length == 0) {
            return null;
        }
        long expectedValue = values.getValue(0);
        IRegBitFieldValueAPI[] iRegBitFieldValueAPIArray = bfVals;
        int n = bfVals.length;
        int n2 = 0;
        while (n2 < n) {
            IRegBitFieldValueAPI bfValue = iRegBitFieldValueAPIArray[n2];
            if (bfValue.matchesValue(expectedValue)) {
                return bfValue;
            }
            ++n2;
        }
        return null;
    }

    protected @NonNull LongValues valuesFromIndices(long @NonNull [] indices) {
        LongValues.Builder builder = new LongValues.Builder();
        int i = 0;
        while (i < indices.length) {
            long bfIndex = indices[i];
            BitFieldElement bitField = this.bitFields[i];
            IRegBitFieldValueAPI[] bitFieldValues = bitField.getBitField().getValues();
            Long value = null;
            if (bitFieldValues.length == 0) {
                value = bfIndex;
                assert (value != null);
                builder.addValue(value);
            } else {
                int j = 0;
                while (j < bitFieldValues.length) {
                    if (bfIndex >= bitFieldValues[j].numberOfValues()) {
                        bfIndex -= bitFieldValues[j].numberOfValues();
                    } else {
                        value = (Long)bitFieldValues[j].getValues(bfIndex, 1).get(0);
                        break;
                    }
                    ++j;
                }
                assert (value != null);
                builder.addValue(value);
            }
            ++i;
        }
        return builder.build();
    }

    protected boolean nextBfValues(long @NonNull [] bfIndices) {
        return this.nextBfValue(0, bfIndices);
    }

    protected boolean nextBfValue(int pos, long @NonNull [] bfIndices) {
        if (pos >= bfIndices.length) {
            return false;
        }
        long prevIdx = bfIndices[pos];
        long nextIdx = 0L;
        boolean found = false;
        BitFieldElement bitField = this.bitFields[pos];
        IRegBitFieldValueAPI[] bitFieldValues = bitField.getBitField().getValues();
        if (bitFieldValues.length == 0) {
            short width = bitField.getBitField().getWidth();
            long maxValue = (1L << width) - 1L;
            if (prevIdx != maxValue) {
                nextIdx = prevIdx + 1L;
                found = true;
            } else {
                nextIdx = 0L;
            }
        } else if (prevIdx + 1L < (long)bitFieldValues.length) {
            nextIdx = prevIdx + 1L;
            found = true;
        } else {
            nextIdx = 0L;
        }
        bfIndices[pos] = nextIdx;
        return found ? true : this.nextBfValue(pos + 1, bfIndices);
    }

    @Override
    public @NonNull IValueMapBuilder setFractional(int fractionalBits) {
        this.fractionalBits = fractionalBits;
        return this;
    }

    @Override
    public IValueMapBuilder setDescriptionsEnabled(boolean enabled) {
        this.enableDescriptions = enabled;
        return this;
    }

    @Override
    public @NonNull IValueMapBuilder setConstraint(@NonNull List<@NonNull Constraint> constraint) {
        this.constraint = constraint;
        return this;
    }
}

