/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.valueMaps.AValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.EntryValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.expression.BitFieldsContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.verification.ExpressionVerificator;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class EntryValueMapBuilder
extends AValueMapBuilder {
    @NonNull
    private @NonNull Map<@NonNull String, ValueEntryRequirement> requirements;
    private static final long ENTRY_MAP_TRESHOLD = (long)Math.pow(2.0, 32.0) - 1L;

    EntryValueMapBuilder(@NonNull Expression expression, @NonNull BitFieldsCache registers) {
        super(registers, expression);
        this.expression = expression;
        this.requirements = new HashMap<String, ValueEntryRequirement>();
    }

    private static boolean increaseIndex(long @NonNull [] maxIndices, long @NonNull [] currentIndices) {
        int i = maxIndices.length - 1;
        while (i >= 0) {
            if (currentIndices[i] < maxIndices[i]) {
                int n = i;
                currentIndices[n] = currentIndices[n] + 1L;
                return true;
            }
            currentIndices[i] = 0L;
            --i;
        }
        return false;
    }

    private long @NonNull [] getMaxIndices() {
        long[] array = new long[this.bitFields.length];
        int i = 0;
        while (i < array.length) {
            long numberOfValues = 0L;
            IRegBitFieldValueAPI[] valueStorrages = this.bitFields[i].getValues();
            if (valueStorrages.length == 0) {
                array[i] = (long)Math.pow(2.0, this.bitFields[i].getWidth()) - 1L;
            } else {
                int j = 0;
                while (j < valueStorrages.length) {
                    numberOfValues += valueStorrages[j].numberOfValues();
                    ++j;
                }
                if (numberOfValues > ENTRY_MAP_TRESHOLD) {
                    LOGGER.warning("Consider using Range value map for bit-field " + this.bitFields[i].getId());
                }
                array[i] = numberOfValues - 1L;
            }
            ++i;
        }
        return array;
    }

    private @NonNull Map<@NonNull LongValues, @NonNull EntryValueMap.ValueEntry> createEntryValues(Map<@NonNull String, @NonNull EntryValueMap.ValueEntry> uiEntries) {
        HashMap<@NonNull LongValues, @NonNull EntryValueMap.ValueEntry> entries = new HashMap<LongValues, EntryValueMap.ValueEntry>();
        long[] currentIndexes = new long[this.bitFields.length];
        long[] maxIndexes = this.getMaxIndices();
        do {
            String description;
            LongValues currentValues = this.valuesFromIndices(currentIndexes);
            BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, currentValues, this.expression.getContext());
            IValue resolvedVal = this.expression.resolve(bfContext);
            String expressionResult = resolvedVal.getString();
            IRegBitFieldValueAPI bfValue = this.getValueFromSingleBf(currentValues);
            String uiValue = expressionResult;
            if (bfValue != null && this.enableDescriptions && (description = bfValue.getDescription()) != null && !description.isEmpty()) {
                uiValue = description;
            }
            EntryValueMap.ValueEntry entry = null;
            if (this.requirements.isEmpty()) {
                if (this.fractionalBits != 0) {
                    String fractionalUiValue = this.createFractionalUiValue(uiValue);
                    entry = new EntryValueMap.ValueEntry(currentValues, fractionalUiValue, uiValue);
                } else {
                    entry = new EntryValueMap.ValueEntry(currentValues, uiValue, uiValue);
                }
            } else if (this.requirements.containsKey(expressionResult)) {
                Object controlValue;
                ValueEntryRequirement requirement = Objects.requireNonNull(this.requirements.get(expressionResult));
                uiValue = requirement.uiValue != null ? requirement.uiValue : uiValue;
                Object object = controlValue = requirement.controlValue != null ? requirement.controlValue : uiValue;
                if (this.fractionalBits != 0) {
                    String fractionalUiValue;
                    uiValue = fractionalUiValue = this.createFractionalUiValue(uiValue);
                }
                entry = new EntryValueMap.ValueEntry(currentValues, uiValue, controlValue);
            }
            if (entry == null) continue;
            if (entries.containsKey(currentValues)) {
                LOGGER.warning("Identical expression result: " + expressionResult + " for different bit-field values: " + (Object)((Object)this.expression));
            }
            entries.put(currentValues, entry);
            uiEntries.put(entry.uiValue, entry);
        } while (EntryValueMapBuilder.increaseIndex(maxIndexes, currentIndexes));
        return entries;
    }

    @Override
    public @NonNull EntryValueMap build() {
        HashMap<@NonNull String, @NonNull EntryValueMap.ValueEntry> uiEntries = new HashMap<String, EntryValueMap.ValueEntry>();
        Map<@NonNull LongValues, @NonNull EntryValueMap.ValueEntry> entries = this.createEntryValues(uiEntries);
        EntryValueMap result = new EntryValueMap(this.expression, this.bitFields, entries, uiEntries, this.fractionalBits);
        ExpressionVerificator.getInstance().addValueMap(result);
        return result;
    }

    @Override
    public IValueMapBuilder addRequirement(@NonNull String expressionResult, @Nullable String uiValue, @Nullable Object controlValue) {
        if (this.requirements.containsKey(expressionResult)) {
            LOGGER.warning("Requirement to expression result of " + expressionResult + " was already defined. Replacing old requirement with the new one");
        }
        this.requirements.put(expressionResult, new ValueEntryRequirement(uiValue, controlValue));
        return this;
    }

    private static class ValueEntryRequirement {
        @Nullable
        String uiValue;
        @Nullable
        Object controlValue;

        ValueEntryRequirement(@Nullable String uiValue, @Nullable Object controlValue) {
            this.uiValue = uiValue;
            this.controlValue = controlValue;
        }

        public String toString() {
            return "(" + this.uiValue + ", " + this.controlValue + ")";
        }
    }
}

