/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.valueMaps.CalculatedValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.EntryValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.RangeValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.SimpleValueMapBuilder;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;

public class ValueMapBuilderFactory {
    private ValueMapBuilderFactory() {
    }

    public static IValueMapBuilder getBuilder(@NonNull Expression expression, @NonNull BitFieldsCache registers, boolean optimalize) {
        Expression reverseExpression = expression.reverse();
        if (expression.equals((Object)Expression.EXPRESSION_TRUE)) {
            return new SimpleValueMapBuilder(registers);
        }
        if (optimalize && reverseExpression != null) {
            if (RangeValueMapBuilder.isAlegible(expression, registers)) {
                return new RangeValueMapBuilder(expression, reverseExpression, registers);
            }
            return new EntryValueMapBuilder(expression, registers);
        }
        if (expression.getBitFields().size() == 2) {
            return new CalculatedValueMapBuilder(registers, expression);
        }
        return new EntryValueMapBuilder(expression, registers);
    }
}

