/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.dependencies;

import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.storage.IDependenciesConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public class SimpleExternalSourceResolverHelper {
    public static @Nullable ClockSource getSimpleExternalSource(IClocksConfig clocksConfig, IClockElement clockElement) {
        List<IClockElement> elementsOnPath = clocksConfig.getPathToOutput(clockElement.getID());
        boolean isSimplePath = elementsOnPath.stream().noneMatch(ClockSelect.class::isInstance);
        ClockSource source = (ClockSource)CollectionsUtils.nullableOptionalGet(elementsOnPath.stream().filter(ClockSource.class::isInstance).findFirst());
        if (isSimplePath && source != null && !source.isInternal() && !source.isConnectedByDefault()) {
            return source;
        }
        return null;
    }

    public static States resolveSimpleExternalSource(IClocksConfig clocksConfig, IClockElement clockElement, ClockSource clockSource) {
        List<ISetting> settings = clockSource.getSettings();
        ClockSourceSetting sourceSetting = (ClockSourceSetting)CollectionsUtils.nullableOptionalGet(settings.stream().filter(ClockSourceSetting.class::isInstance).findFirst());
        if (sourceSetting != null) {
            Shell activeShell = GuiController.getActiveShell();
            int result = GuiController.getInstance().changeUserEnableStateOf(sourceSetting, clocksConfig, activeShell, false);
            if (result == 0) {
                if (clockElement.isEnabled(clocksConfig)) {
                    return SimpleExternalSourceResolverHelper.isPathValid(clocksConfig, clockElement) ? States.OK : States.PROBLEMATIC;
                }
                return States.DISABLED;
            }
            return States.CANCELED;
        }
        return States.OTHER;
    }

    private static boolean isPathValid(IClocksConfig clocksConfig, IClockElement clockElement) {
        List<IClockElement> path = clocksConfig.getPathToOutput(clockElement.getID());
        for (IClockElement e : path) {
            if (e.isValid(clocksConfig)) continue;
            return false;
        }
        return true;
    }

    public static Map<ISetting, SettingValue> getOriginalSettings(IClocksConfig clocksConfig, ClockSource clockSource) {
        SettingsConfig settingsConfig = clocksConfig.getSettingsConfig();
        List<ISetting> settings = clockSource.getSettings();
        HashMap<ISetting, SettingValue> originalSettings = new HashMap<ISetting, SettingValue>();
        settings.forEach(setting -> {
            SettingValue settingValue = originalSettings.put((ISetting)setting, settingsConfig.getSettingValue((ISetting)setting));
        });
        return originalSettings;
    }

    public static void showErrorMessageDialog(IClockElement clockElement) {
        Shell shell = GuiController.getActiveShell();
        SettingEditorHelper.showEnableOutputClockFailedDialog(clockElement.getID(), shell, false);
    }

    public static void rollBackSettings(IClocksConfig clocksConfig, Map<ISetting, SettingValue> settings, IBaseProblem baseProblem) {
        IDependenciesConfiguration configuration;
        settings.forEach((setting, value) -> {
            clocksConfig.setSettingValue((ISetting)setting, (SettingValue)value, true, true);
            if (setting instanceof ClockSourceSetting) {
                clocksConfig.getSettingsConfig().setUserEnabled((ISetting)setting, false);
                clocksConfig.getSettingsConfig().setLockState((ISetting)setting, new LockState((ISetting)setting, SettingValue.UNDEFINED, SettingsConfig.DEFAULT_ACCURACY));
            }
        });
        if (baseProblem instanceof IValidationProblem && (configuration = ((IValidationProblem)baseProblem).getConfiguration()) instanceof StorageClocksConfiguration) {
            List sources = ((StorageClocksConfiguration)configuration).getSources();
            clocksConfig.getStorageConfig().setSources(sources);
        }
    }

    public static enum States {
        OK,
        CANCELED,
        DISABLED,
        PROBLEMATIC,
        OTHER;

    }
}

