/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.expression;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.FunctionInvocation;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.expert.processor.properties.PackageProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;

public class ConfigContext
implements IContext {
    @NonNull
    private IContext parentContext;
    @NonNull
    private IClocksConfig config;

    public ConfigContext(@NonNull IContext parentContext, @NonNull IClocksConfig config) {
        this.parentContext = parentContext;
        this.config = config;
    }

    public long getBitFieldValue(@NonNull String registerName, @NonNull String bitFieldName) {
        String bitFieldId = this.getBitFieldId(registerName, bitFieldName);
        return ClocksBitFieldProvider.getValueByBitFieldId(bitFieldId, this.config);
    }

    public @NonNull Object getSettingValue(@NonNull String settingName) {
        SettingsConfig settingsConfig;
        IMcu mcu;
        ICommonConfig commonConfig;
        Object propertyValue;
        if (PackageProperties.isProperty((String)settingName) && (propertyValue = PackageProperties.getProperty((String)settingName, (IMcuIdentification)(commonConfig = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig()).getMcuIdentification())) != null) {
            return propertyValue;
        }
        String settingID = this.getSettingId(settingName);
        SettingValue value = SettingProvider.getValueBySettingId(settingID, mcu = this.config.getMcu(), settingsConfig = this.config.getSettingsConfig());
        if (value != null) {
            return Converter.convertToLRBS(value.getValue());
        }
        return SettingValue.N_A.getValue();
    }

    public int getBitFiledWidth(@NonNull String registerName, @NonNull String bitFieldName) {
        BitFieldsCache registers;
        String bitFieldId = this.getBitFieldId(registerName, bitFieldName);
        BitFieldElement bitField = ClocksBitFieldProvider.getBitFieldById(bitFieldId, registers = this.config.getMcu().getBitFieldsCache());
        if (bitField != null) {
            return bitField.getWidth();
        }
        return 0;
    }

    public @NonNull String getBitFieldId(@NonNull String registerName, @NonNull String bitFieldName) {
        return this.parentContext.getBitFieldId(registerName, bitFieldName);
    }

    public @NonNull IValue resolveFunction(@NonNull FunctionInvocation function, @NonNull IContext argContext) {
        return this.parentContext.resolveFunction(function, argContext);
    }

    public @NonNull String getSettingId(@NonNull String settingName) {
        return this.parentContext.getSettingId(settingName);
    }
}

