/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.expression;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Constant;
import com.nxp.swtools.common.utils.expression.EmptyContext;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Operator;
import com.nxp.swtools.common.utils.expression.OperatorType;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@NonNullByDefault
public class SwitchOperator
extends Operator {
    protected Map<String, IResolvable> cases;

    protected SwitchOperator(Map<String, IResolvable> cases, IResolvable defaultCase, IResolvable condition) {
        super(OperatorType.CUSTOM, SwitchOperator.extractArgs(cases, defaultCase, condition));
        this.cases = cases;
    }

    private static IResolvable[] extractArgs(Map<String, IResolvable> cases, IResolvable defaultCase, IResolvable condition) {
        IResolvable[] args = new IResolvable[cases.size() + 2];
        int idx = 0;
        args[idx] = condition;
        ++idx;
        Iterator<IResolvable> iterator = cases.values().iterator();
        while (iterator.hasNext()) {
            IResolvable arg;
            args[idx] = arg = iterator.next();
            ++idx;
        }
        args[idx] = defaultCase;
        return args;
    }

    public IValue resolve(IContext context) {
        IResolvable caseResolvable = this.cases.get(this.getCondition().resolve(context).getString());
        if (caseResolvable == null) {
            caseResolvable = this.getDefaultCase();
        }
        return caseResolvable.resolve(context);
    }

    public String getOperatorSign() {
        return "SWITCH";
    }

    protected void appendArguments(String prefix, StringBuilder stringBuilder) {
        stringBuilder.append(prefix).append("CONDITION:\n").append(this.getCondition().print(prefix, false));
        for (Map.Entry<String, IResolvable> caseEntry : this.cases.entrySet()) {
            stringBuilder.append(prefix).append("CASE `").append(caseEntry.getKey()).append("`:\n").append(caseEntry.getValue().print(prefix, false));
        }
        stringBuilder.append("DEFAULT:\n").append(this.getDefaultCase().print(prefix, true));
    }

    public IResolvable getCondition() {
        return this.arguments[0];
    }

    public IResolvable getDefaultCase() {
        return this.arguments[this.arguments.length - 1];
    }

    public IResolvable simplify() {
        for (Map.Entry<String, IResolvable> caseEntry : this.cases.entrySet()) {
            caseEntry.setValue(caseEntry.getValue().simplify());
        }
        this.arguments = SwitchOperator.extractArgs(this.cases, this.getDefaultCase().simplify(), this.getCondition().simplify());
        if (this.getCondition() instanceof Constant) {
            IResolvable caseResolvable = this.cases.get(this.getCondition().resolve((IContext)EmptyContext.getInstsance()).getString());
            if (caseResolvable == null) {
                caseResolvable = this.getDefaultCase();
            }
            return caseResolvable;
        }
        return this;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.cases);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SwitchOperator other = (SwitchOperator)((Object)obj);
        return Objects.equals(this.cases, other.cases);
    }
}

