/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.handlers;

import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.utils.ClocksSourcesHelper;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import java.util.Collection;

@NonNullByDefault
public class ClocksToolCodeGeneration
implements ISourceFileProvider {
    public ISourceFileGenerationStatus getGeneratedFiles(String coreId, Collection<ISourceFile> generatedFiles) {
        ScriptResult scriptResult = UiController.getInstance().getProfile().getGeneratedCode();
        ProcessorCore processorCore = ClocksSourcesHelper.getProcessorCore(coreId);
        AExportWizard.GenerationResult result = ClocksSourcesHelper.getGeneratedSources(processorCore);
        if (!result.wasSuccessful) {
            return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.FATAL, (String)UtilsText.safeString((String)result.failReason));
        }
        @Nullable Collection genFiles = result.getGeneratedSourceFiles();
        if (genFiles == null) {
            assert (false);
            return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.FATAL, (String)"There are no generated files");
        }
        generatedFiles.addAll(genFiles);
        if (!scriptResult.getErrors().isEmpty() || !scriptResult.getWarnings().isEmpty()) {
            return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.WARNING, (String)Messages.get().CodeGeneration_ScriptProblem);
        }
        return SourceFileProviderFactory.buildGenerationOKStatus();
    }
}

