/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.handlers;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.toolchainproject.RefreshProjectHandler;
import com.nxp.swtools.utils.dialog.ToolsProgressMonitorDialog;
import com.nxp.swtools.utils.events.ToolEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshHandler
extends RefreshProjectHandler {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(RefreshHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Shell shell = window.getShell();
        if (shell != null) {
            ToolsProgressMonitorDialog pmd = new ToolsProgressMonitorDialog(shell);
            pmd.setCancelable(false);
            pmd.create();
            List<@NonNull IClocksConfig> configs = UiController.getInstance().getProfile().getConfigs();
            try {
                String taskName = Messages.get().RefreshHandler_Refreshing;
                pmd.run(true, false, monitor -> {
                    monitor.beginTask(taskName, configs.size());
                    configs.forEach(x -> {
                        x.recompute(null);
                        monitor.worked(1);
                    });
                    UiController.getInstance().fireListeners(new ToolEvent.Builder(64).build());
                    monitor.done();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.log(Level.WARNING, "Refreshing did not finish properly", e);
            }
        }
        return null;
    }
}

