/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.script;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public final class ClocksRepresenter
extends Representer {
    public ClocksRepresenter() {
        this.setPropertyUtils(new PropertyUtils(){

            protected Set<Property> createPropertySet(Class<? extends Object> type, BeanAccess bAccess) {
                Set properties = super.createPropertySet(type, bAccess);
                TreeSet<Property> propertiesSorted = new TreeSet<Property>(PropertyComparator.getInstance());
                propertiesSorted.addAll(properties);
                return propertiesSorted;
            }
        });
    }

    protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof String && ((String)propertyValue).isEmpty()) {
            return null;
        }
        if (propertyValue instanceof Boolean && !((Boolean)propertyValue).booleanValue()) {
            return null;
        }
        if (propertyValue instanceof Collection && ((Collection)propertyValue).isEmpty()) {
            return null;
        }
        if (property.getName().equals("dependencies")) {
            return null;
        }
        return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
    }

    private static final class PropertyComparator
    implements Comparator<Property> {
        @NonNull
        private static final PropertyComparator INSTANCE = new PropertyComparator();
        @NonNull
        private static final @NonNull Map<@NonNull String, @Nullable Integer> ORDINALS = new HashMap<String, Integer>();

        static {
            ORDINALS.put("id", 0);
            ORDINALS.put("name", 1);
            ORDINALS.put("description", 2);
            ORDINALS.put("value", 3);
            ORDINALS.put("locked", 4);
            ORDINALS.put("accuracy", 5);
            ORDINALS.put("product", 6);
            ORDINALS.put("processor", 7);
            ORDINALS.put("package_id", 8);
            ORDINALS.put("mcu_data", 9);
            ORDINALS.put("processor_version", 10);
            ORDINALS.put("board", 11);
            ORDINALS.put("kit", 12);
        }

        private PropertyComparator() {
        }

        public static final @NonNull PropertyComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public final int compare(Property o1, Property o2) {
            int ordinalCompare = PropertyComparator.ordinal(o1) - PropertyComparator.ordinal(o2);
            if (ordinalCompare == 0) {
                return o1.compareTo(o2);
            }
            return ordinalCompare;
        }

        private static final int ordinal(@Nullable Property property) {
            Integer ordinal;
            if (property != null && (ordinal = ORDINALS.get(property.getName())) != null) {
                return ordinal;
            }
            return ORDINALS.size();
        }
    }
}

