/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.script;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.script.ClocksYamlConverter;
import com.nxp.swtools.clocks.script.Configuration;
import com.nxp.swtools.clocks.utils.ClockElementUtils;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import java.math.BigInteger;
import java.util.Collection;
import java.util.logging.Logger;

public class ConfigurationImpl
implements Configuration {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationImpl.class);
    @NonNull
    private final IClocksConfig clocksConfig;
    @NonNull
    private final IMcu mcu;

    public ConfigurationImpl(@NonNull IClocksConfig clockConfig, @NonNull IMcu mcu) {
        this.clocksConfig = clockConfig;
        this.mcu = mcu;
    }

    @Override
    public long getBitFieldValue(String register, String bitField) {
        return ClocksBitFieldProvider.getValueOfBitField(register, bitField, this.clocksConfig);
    }

    @Override
    public String getValueAsText(String id) {
        SettingValue value = SettingProvider.getValueBySettingId(id, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return value.getValue().toString();
        }
        LOGGER.warning("Value of setting not found: " + id);
        return null;
    }

    @Override
    public double getValueAsDecimal(String id) {
        SettingValue value = SettingProvider.getValueBySettingId(id, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return ConfigurationImpl.toDouble(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return -1.0;
    }

    @Override
    public long getValueAsInteger(String id) {
        SettingValue value = SettingProvider.getValueBySettingId(id, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return ConfigurationImpl.toLong(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return -1L;
    }

    @Override
    public @Nullable BigInteger getValueAsBigInteger(@NonNull String id) {
        SettingValue value = SettingProvider.getValueBySettingId(id, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return ConfigurationImpl.toBigInt(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return null;
    }

    @Override
    public @Nullable String getDefaultValueAsText(@NonNull String id) {
        SettingValue value = SettingProvider.getDefaultValueBySettingId(id, this.mcu, this.clocksConfig);
        if (value != null) {
            return value.getValue().toString();
        }
        LOGGER.warning("Value of setting not found: " + id);
        return null;
    }

    @Override
    public double getDefaultValueAsDecimal(@NonNull String id) {
        SettingValue value = SettingProvider.getDefaultValueBySettingId(id, this.mcu, this.clocksConfig);
        if (value != null) {
            return ConfigurationImpl.toDouble(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return -1.0;
    }

    @Override
    public @Nullable BigInteger getDefaultValueAsBigInteger(@NonNull String id) {
        SettingValue value = SettingProvider.getDefaultValueBySettingId(id, this.mcu, this.clocksConfig);
        if (value != null) {
            return ConfigurationImpl.toBigInt(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return null;
    }

    @Override
    public long getDefaultValueAsInteger(@NonNull String id) {
        SettingValue value = SettingProvider.getDefaultValueBySettingId(id, this.mcu, this.clocksConfig);
        if (value != null) {
            return ConfigurationImpl.toLong(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return -1L;
    }

    @Override
    public boolean getDefaultValueAsBool(@NonNull String id) {
        SettingValue value = SettingProvider.getDefaultValueBySettingId(id, this.mcu, this.clocksConfig);
        if (value != null) {
            return (Boolean)Converter.convertToLRBS(value.getValue());
        }
        throw new IllegalArgumentException("Unknown setting id: " + id);
    }

    private static final double toDouble(@NonNull Object object) {
        Object objectToConvert = object;
        if (objectToConvert instanceof Frequency) {
            return Converter.toHertz((Frequency)objectToConvert).doubleValue();
        }
        if (objectToConvert instanceof Number) {
            return ((Number)objectToConvert).doubleValue();
        }
        String stringValue = objectToConvert.toString();
        return Double.parseDouble(stringValue);
    }

    private static final long toLong(@NonNull Object object) {
        Object objectToConvert = object;
        if (objectToConvert instanceof Frequency) {
            return Double.valueOf(Converter.toHertz((Frequency)objectToConvert).doubleValue()).longValue();
        }
        if (objectToConvert instanceof Number) {
            return ((Number)objectToConvert).longValue();
        }
        String stringValue = objectToConvert.toString();
        return Long.parseLong(stringValue);
    }

    private static final @NonNull BigInteger toBigInt(@NonNull Object object) {
        Object objectToConvert = object;
        if (objectToConvert instanceof Frequency) {
            BigRational rational = Converter.toHertz((Frequency)objectToConvert);
            @NonNull BigInteger result = rational.getNumerator().divide(rational.getDenominator());
            return result;
        }
        if (objectToConvert instanceof BigInteger) {
            return (BigInteger)objectToConvert;
        }
        if (objectToConvert instanceof Number) {
            @NonNull BigInteger result = BigInteger.valueOf(((Number)objectToConvert).longValue());
            return result;
        }
        String stringValue = objectToConvert.toString();
        return new BigInteger(stringValue);
    }

    @Override
    public String getYaml() {
        IClocksProfile clocksProfile = this.clocksConfig.getProfile();
        if (clocksProfile != null && clocksProfile.isYamlEnabled()) {
            return new ClocksYamlConverter().createYamlFunction(this.clocksConfig.getStorageConfig());
        }
        return null;
    }

    public @NonNull String getName() {
        return this.clocksConfig.getName();
    }

    public @NonNull String getDescription() {
        return this.clocksConfig.getDescription();
    }

    @Override
    public boolean isBitFieldValueAvailable(String register, String bitField) {
        return ClocksBitFieldProvider.isBitFieldValueAvailable(register, bitField, this.mcu.getBitFieldsCache(), this.clocksConfig);
    }

    @Override
    public boolean isBitFieldAvailable(@NonNull String register, @NonNull String bitField) {
        return ClocksBitFieldProvider.isBitFieldAvailable(register, bitField, this.mcu.getBitFieldsCache(), this.clocksConfig);
    }

    @Override
    public @NonNull BitFieldElement @NonNull [] getConfiguredBitFields() {
        @NonNull Collection<@NonNull BitFieldElement> collection = ClocksBitFieldProvider.getConfiguredBitFields(this.clocksConfig);
        @NonNull BitFieldElement[] array = new BitFieldElement[collection.size()];
        array = collection.toArray(array);
        assert (array != null);
        return array;
    }

    @Override
    public @NonNull BitFieldElement @NonNull [] getBitFieldsNonDefault() {
        @NonNull Collection<@NonNull BitFieldElement> collection = ClocksBitFieldProvider.getBitFieldsNonDefault(this.clocksConfig);
        @NonNull BitFieldElement[] array = new BitFieldElement[collection.size()];
        array = collection.toArray(array);
        assert (array != null);
        return array;
    }

    @Override
    public long getBitFieldValue(@NonNull BitFieldElement bitField) {
        IRegBitFieldValueAPI bitFieldValue = ClocksBitFieldProvider.getBitFieldValueNullable(bitField, this.clocksConfig);
        if (bitFieldValue == null) {
            return -1L;
        }
        return bitFieldValue.getValue();
    }

    @Override
    public boolean getValueAsBool(@NonNull String id) {
        SettingValue value = SettingProvider.getValueBySettingId(id, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return (Boolean)Converter.convertToLRBS(value.getValue());
        }
        throw new IllegalArgumentException("Unknown setting id: " + id);
    }

    @Override
    public @NonNull String @NonNull [] getClockSourceSettings() {
        return ConfigurationImpl.getSettingIds(this.mcu.getSettings().getClockSources());
    }

    @Override
    public @NonNull String @NonNull [] getClockOutputConsumers(@NonNull String clockOutputId) {
        IClockElement clockElement = this.mcu.getClockElement(clockOutputId);
        if (clockElement instanceof ClockOutput) {
            return (String[])CollectionsUtils.toArray(ClockElementUtils.getClocksOutputConsumers((ClockOutput)clockElement, this.clocksConfig), String.class);
        }
        return new String[]{""};
    }

    @Override
    public @NonNull String @NonNull [] getClockOutputSettings() {
        return ConfigurationImpl.getSettingIds(this.mcu.getSettings().getClockOutputs());
    }

    @Override
    public @NonNull String @NonNull [] getGlobalSettings() {
        return ConfigurationImpl.getSettingIds(this.mcu.getSettings().getGlobalSettings());
    }

    @Override
    public @NonNull String @NonNull [] getGeneralSettings() {
        return ConfigurationImpl.getSettingIds(this.mcu.getSettings().getGeneralSettings());
    }

    private static @NonNull String @NonNull [] getSettingIds(@NonNull Collection<? extends @NonNull ISetting> settings) {
        @NonNull String[] ids = new String[settings.size()];
        int pos = 0;
        for (ISetting iSetting : settings) {
            ids[pos] = iSetting.getId();
            ++pos;
        }
        return ids;
    }

    @Override
    public long getShiftedBitFieldValue(@NonNull String register, @NonNull String bitFieldName) {
        BitFieldElement bitField = ClocksBitFieldProvider.getBitField(register, bitFieldName, this.mcu.getBitFieldsCache());
        if (bitField == null) {
            LOGGER.warning("Bit field not found: " + bitField);
            return -1L;
        }
        return this.getShiftedBitFieldValue(bitField);
    }

    @Override
    public long getShiftedBitFieldValue(@NonNull BitFieldElement bitField) {
        IRegBitFieldValueAPI bitFieldValue = ClocksBitFieldProvider.getBitFieldValueNullable(bitField, this.clocksConfig);
        if (bitFieldValue == null) {
            LOGGER.warning("Bit field value not initialized: " + bitField);
            return -1L;
        }
        long longValue = bitFieldValue.getValue();
        short offset = bitField.getOffset();
        if (Long.numberOfLeadingZeros(longValue) - offset < 0 || offset >= 64) {
            LOGGER.warning("Long overflow for shifted bit field: " + bitField + ", value: " + longValue + " << " + offset);
            return -1L;
        }
        return longValue << offset;
    }

    @Override
    public @Nullable BitFieldElement findBitField(@NonNull String register, @NonNull String bitField) {
        return ClocksBitFieldProvider.getBitField(register, bitField, this.mcu.getBitFieldsCache());
    }

    @Override
    public @Nullable BigInteger getBitFieldValueAsBigInteger(@NonNull String register, @NonNull String bitField) {
        BitFieldElement bitFieldObject = ClocksBitFieldProvider.getBitField(register, bitField, this.mcu.getBitFieldsCache());
        if (bitFieldObject != null) {
            return this.getBitFieldValueAsBigInteger(bitFieldObject);
        }
        return null;
    }

    @Override
    public @Nullable BigInteger getBitFieldValueAsBigInteger(@NonNull BitFieldElement bitField) {
        IRegBitFieldValueAPI bfVal = ClocksBitFieldProvider.getBitFieldValueNullable(bitField, this.clocksConfig);
        if (bfVal != null) {
            return ClocksBitFieldProvider.convertLongBFValueToBigInteger(bfVal.getValue(), bitField);
        }
        return null;
    }

    @Override
    public @Nullable BigInteger getShiftedBitFieldValueAsBigInteger(@NonNull String register, @NonNull String bitField) {
        BitFieldElement bitFieldObject = ClocksBitFieldProvider.getBitField(register, bitField, this.mcu.getBitFieldsCache());
        if (bitFieldObject != null) {
            return this.getShiftedBitFieldValueAsBigInteger(bitFieldObject);
        }
        return null;
    }

    @Override
    public @Nullable BigInteger getShiftedBitFieldValueAsBigInteger(@NonNull BitFieldElement bitField) {
        IRegBitFieldValueAPI bitFieldValue = ClocksBitFieldProvider.getBitFieldValueNullable(bitField, this.clocksConfig);
        if (bitFieldValue == null) {
            LOGGER.warning("Bit field value not initialized: " + bitField);
            return null;
        }
        long longValue = bitFieldValue.getValue();
        BigInteger bigIntValue = new BigInteger(Long.toBinaryString(longValue), 2);
        short offset = bitField.getOffset();
        return bigIntValue.shiftLeft(offset);
    }

    @Override
    public boolean existsId(@NonNull String id) {
        if (this.mcu.getSettings().findSettingWithId(id) != null) {
            return true;
        }
        if (this.mcu.getClockElement(id) != null) {
            return true;
        }
        return this.mcu.getClockComponent(id) != null;
    }

    @Override
    public @NonNull String @NonNull [] getElementIds() {
        return this.mcu.getAllElements().keySet().toArray(new String[0]);
    }

    @Override
    public @NonNull String @NonNull [] getComponentIds() {
        return this.mcu.getClockComponents().keySet().toArray(new String[0]);
    }

    public boolean isCalledFromDefaultInit() {
        return this.clocksConfig.isCalledFromDefaultInit();
    }

    @Override
    public @Nullable String getValueAsText(@NonNull String id, @NonNull String powerMode) {
        SettingValue value = SettingProvider.getValueBySettingId(id, powerMode, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return value.getValue().toString();
        }
        LOGGER.warning("Value of setting not found: " + id);
        return null;
    }

    @Override
    public double getValueAsDecimal(@NonNull String id, @NonNull String powerMode) {
        SettingValue value = SettingProvider.getValueBySettingId(id, powerMode, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return ConfigurationImpl.toDouble(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return -1.0;
    }

    @Override
    public @Nullable BigInteger getValueAsBigInteger(@NonNull String id, @NonNull String powerMode) {
        SettingValue value = SettingProvider.getValueBySettingId(id, powerMode, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return ConfigurationImpl.toBigInt(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return null;
    }

    @Override
    public long getValueAsInteger(@NonNull String id, @NonNull String powerMode) {
        SettingValue value = SettingProvider.getValueBySettingId(id, powerMode, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return ConfigurationImpl.toLong(value.getValue());
        }
        LOGGER.warning("Value of setting not found: " + id);
        return -1L;
    }

    @Override
    public boolean getValueAsBool(@NonNull String id, @NonNull String powerMode) {
        SettingValue value = SettingProvider.getValueBySettingId(id, powerMode, this.mcu, this.clocksConfig.getSettingsConfig());
        if (value != null) {
            return (Boolean)Converter.convertToLRBS(value.getValue());
        }
        throw new IllegalArgumentException("Unknown setting id: " + id);
    }

    @Override
    public @NonNull String getIdPrefix() {
        return this.clocksConfig.getIdPrefix();
    }
}

