/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.script;

import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

public class McuInfo
implements IMcuInfo {
    @NonNull
    private final IMcuDescriptor mcuDescriptor;
    @Nullable
    private final String board;
    @Nullable
    private final String kit;

    public McuInfo(@NonNull IMcuDescriptor mcuDescriptor, @Nullable String board, @Nullable String kit) {
        this.mcuDescriptor = mcuDescriptor;
        this.board = board;
        this.kit = kit;
    }

    public String getPartNumber() {
        return this.mcuDescriptor.getID();
    }

    public String getSeries() {
        return this.mcuDescriptor.getSeries();
    }

    public String getFamily() {
        return this.mcuDescriptor.getFamily();
    }

    public String getDataVersion() {
        return this.mcuDescriptor.getVersion();
    }

    public @NonNull String getPackage() {
        return UtilsText.safeString((String)this.mcuDescriptor.getPartNumber());
    }

    public @NonNull String getSdkVersion() {
        return UtilsText.safeString((String)this.mcuDescriptor.getSDKVersion());
    }

    public @Nullable String getMexVariant() {
        return this.mcuDescriptor.getMexVariant();
    }

    public String getBoard() {
        return this.board;
    }

    public String getKit() {
        return this.kit;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull JSONObject getCoresList() {
        JSONObject res = new JSONObject();
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        @NonNull @NonNull Collection cores = config.getCommonConfig().getCores();
        for (ProcessorCore onecore : cores) {
            JSONObject core = new JSONObject();
            try {
                core.put("name", (Object)onecore.getName());
                core.put("id", (Object)onecore.getID());
                core.put("description", (Object)onecore.getDescription());
                core.put("enabled", true);
                res.put(onecore.getID(), (Object)core);
            }
            catch (JSONException e) {
                assert (false) : e.getMessage();
            }
        }
        assert (res != null);
        return res;
    }
}

