/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.script;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.registers.ClocksBitFieldsContentProvider;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegisterAPI;
import com.nxp.swtools.utils.registers.BitFieldInfo;
import com.nxp.swtools.utils.registers.RegistersDataAdapter;
import com.nxp.swtools.utils.scripting.api.ScriptUtils;
import com.nxp.swtools.utils.scripting.api.ScriptUtilsHelper;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@NonNullByDefault
public class RegistersDefinesGenerator {
    private static final String FUNCTIONAL_GROUP_COMMENT_HEADER = "/* Definitions for {0} functional group */";
    private static final String COMMENT_BEGIN = "/* ";
    private static final String COMMENT_END = " */";
    private static final String REGISTER_SUFFIX = "_INIT ";
    private static final String DEFINE = "#define ";
    private static final String NEW_LINE = System.lineSeparator();
    private static final String SEPARATOR = ", ";
    private static final String DELIMITER = ": ";
    private static final String ASSIGNMENT_SIGN = "=";

    public static String generateContent(List<IClocksConfig> configs) {
        StringBuilder registersDefines = new StringBuilder();
        int i = 0;
        while (i < configs.size()) {
            IClocksConfig config = configs.get(i);
            registersDefines.append(MessageFormat.format(FUNCTIONAL_GROUP_COMMENT_HEADER, config.getName())).append(NEW_LINE);
            Map<IRegisterAPI, Collection<BitFieldInfo>> registersWithBitfields = RegistersDefinesGenerator.getRegistersWithBitfields(config);
            RegistersDefinesGenerator.sortBitfields(registersWithBitfields);
            registersWithBitfields.entrySet().forEach(entry -> {
                IRegisterAPI register = (IRegisterAPI)entry.getKey();
                registersDefines.append(RegistersDefinesGenerator.generateRegisterComment(register, (Collection)entry.getValue()));
                registersDefines.append(RegistersDefinesGenerator.generateRegisterDefine(register, (Collection)entry.getValue(), config));
            });
            if (i != configs.size() - 1) {
                registersDefines.append(NEW_LINE);
            }
            ++i;
        }
        return registersDefines.toString();
    }

    private static String generateRegisterComment(IRegisterAPI register, Collection<BitFieldInfo> bitFieldInfos) {
        StringBuilder comment = new StringBuilder();
        String bitFields = UtilsText.join(bitFieldInfos.stream().map(x -> String.valueOf(x.getBitFieldName()) + ASSIGNMENT_SIGN + x.getValue()), (String)SEPARATOR);
        comment.append(COMMENT_BEGIN).append(register.getName()).append(DELIMITER).append(bitFields).append(COMMENT_END).append(NEW_LINE);
        return comment.toString();
    }

    private static void sortBitfields(Map<IRegisterAPI, Collection<BitFieldInfo>> registersWithBitfields) {
        registersWithBitfields.entrySet().forEach(entry -> {
            List sortedValue = ((Collection)entry.getValue()).stream().sorted((bf1, bf2) -> Short.compare(bf2.getBitFieldAPI().getOffset(), bf1.getBitFieldAPI().getOffset())).collect(Collectors.toList());
            entry.setValue(sortedValue);
        });
    }

    private static String generateRegisterDefine(IRegisterAPI register, Collection<BitFieldInfo> bitFieldInfos, IClocksConfig config) {
        StringBuilder define = new StringBuilder();
        String prefix = config.getIdPrefix();
        if (!config.isPrefixUserDefined()) {
            prefix = String.valueOf(config.getName().toUpperCase()) + "_";
        }
        define.append(DEFINE).append(prefix).append(RegistersDefinesGenerator.getRegisterWithPeripheralName(bitFieldInfos)).append(REGISTER_SUFFIX);
        BigInteger defaultValue = RegistersDataAdapter.getResetValue((IRegisterAPI)register);
        BigInteger registerValue = RegistersDataAdapter.getRegisterValue((BigInteger)defaultValue, bitFieldInfos);
        String hexValue = ScriptUtilsHelper.formatHexValue((BigInteger)registerValue, (int)0);
        define.append(hexValue).append(NEW_LINE);
        return define.toString();
    }

    private static String getRegisterWithPeripheralName(Collection<BitFieldInfo> bitFieldInfos) {
        BitFieldInfo bitFieldInfo = (BitFieldInfo)CollectionsUtils.firstOrNull(bitFieldInfos);
        if (bitFieldInfo != null) {
            return bitFieldInfo.getFullRegisterName();
        }
        return "";
    }

    private static Map<IRegisterAPI, Collection<BitFieldInfo>> getRegistersWithBitfields(IClocksConfig config) {
        List bitFieldInfos = (List)ClocksBitFieldsContentProvider.getBitFieldInfo(config);
        CollectionMap result = new ScriptUtils().createRegistersMap(bitFieldInfos, false);
        return result.entrySet().stream().sorted((e1, e2) -> RegistersDefinesGenerator.getRegisterWithPeripheralName((Collection)e1.getValue()).compareTo(RegistersDefinesGenerator.getRegisterWithPeripheralName((Collection)e2.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }
}

