/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.script;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.script.ClocksProfileInfo;
import com.nxp.swtools.clocks.script.ClocksYamlConverter;
import com.nxp.swtools.clocks.script.Configuration;
import com.nxp.swtools.clocks.script.ConfigurationImpl;
import com.nxp.swtools.clocks.script.McuInfo;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.resourcetables.model.data.RegisterModelAPI;
import com.nxp.swtools.utils.scripting.ScriptDependencyHelper;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import com.nxp.swtools.utils.scripting.api.IRegisterModelAPI;
import com.nxp.swtools.utils.scripting.api.IScriptDependencyHelper;
import com.nxp.swtools.utils.scripting.api.IScriptProfile;
import java.util.Collection;
import java.util.List;

public class ScriptProfile
implements IScriptProfile {
    @NonNull
    private final IRegistersDatabaseAPI registersDB;
    @NonNull
    private final @NonNull Configuration @NonNull [] configurations;
    @NonNull
    private final IMcuInfo mcuInfo;
    @NonNull
    private final ScriptDependencyHelper dependencyHelper;
    private boolean yamlEnabled;
    private IRegisterModelAPI clocksRegisterModel;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ScriptProfile(@NonNull IClocksProfile profile) {
        List<@NonNull IClocksConfig> clockConfigs = profile.getConfigs();
        IMcu mcu = profile.getMcu();
        this.yamlEnabled = profile.isYamlEnabled();
        this.registersDB = mcu.getRegisters();
        this.mcuInfo = new McuInfo(mcu.getMcuDescriptor(), profile.getBoard(), profile.getKit());
        this.configurations = new Configuration[clockConfigs.size()];
        @NonNull List storageConfigs = (List)clockConfigs.stream().map(IClocksConfig::getStorageConfig).collect(CollectorsUtils.toList());
        this.dependencyHelper = new ScriptDependencyHelper((Collection)storageConfigs, false);
        int i = 0;
        for (IClocksConfig clockConfig : clockConfigs) {
            this.configurations[i++] = new ConfigurationImpl(clockConfig, mcu);
        }
        this.clocksRegisterModel = new RegisterModelAPI(mcu.getRegisters());
    }

    public @NonNull Configuration @NonNull [] getConfigurations() {
        return this.configurations;
    }

    public @NonNull IRegistersDatabaseAPI getRegistersDB() {
        return this.registersDB;
    }

    public @NonNull String getToolName() {
        return "Clocks";
    }

    public @NonNull String getToolVersion() {
        return StorageClocksTool.CLOCKS_TOOL_VERSION;
    }

    public @NonNull IMcuInfo getMcuInfo() {
        return this.mcuInfo;
    }

    public String getYaml() {
        if (this.yamlEnabled) {
            ClocksProfileInfo profileInfo = new ClocksProfileInfo();
            profileInfo.setProduct(String.valueOf(this.getToolName()) + " " + "v" + this.getToolVersion());
            profileInfo.setProcessor(this.mcuInfo.getPartNumber());
            profileInfo.setPackage_id(this.mcuInfo.getPackage());
            profileInfo.setProcessor_version(this.mcuInfo.getDataVersion());
            profileInfo.setMcu_data(this.mcuInfo.getSdkVersion());
            profileInfo.setBoard(this.mcuInfo.getBoard());
            profileInfo.setKit(this.mcuInfo.getKit());
            profileInfo.setMex_variant(this.mcuInfo.getMexVariant());
            return new ClocksYamlConverter().createYamlProfile(profileInfo);
        }
        return null;
    }

    public @NonNull IScriptDependencyHelper getDependencyHelper() {
        return this.dependencyHelper;
    }

    void close(boolean generatedSuccessfuly) {
        if (generatedSuccessfuly) {
            this.dependencyHelper.applyScriptDependencies();
        }
    }

    public @Nullable IRegisterModelAPI getRegisterModelAPI() {
        return this.clocksRegisterModel;
    }
}

