/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.EmptyConfig;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.WidgetFactory;
import com.nxp.swtools.clocks.ui.diagram.SliceDiagramDialog;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.clocks.ui.table.SettingsFilter;
import com.nxp.swtools.clocks.ui.table.SettingsInput;
import com.nxp.swtools.clocks.ui.table.SettingsTable;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.utils.events.IEventListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DetailsWindow {
    @NonNull
    private final SettingsTable detailsTable;
    @NonNull
    private final Label labelTitle;
    @NonNull
    private final GuiController guiController = GuiController.getInstance();
    @NonNull
    private final @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();
    @Nullable
    private String contentID;
    @Nullable
    private ISelectionChangedListener tableSelectionListener;
    @NonNull
    private SettingsFilter settingsFilter = new SettingsFilter(new EmptyConfig(this.guiController.getProfile().getMcu(), ""));

    public DetailsWindow(@NonNull Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.labelTitle = WidgetFactory.createTitle(parent, "");
        this.labelTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.refreshTitle();
        this.detailsTable = new SettingsTable(parent, "details", true, true, 770);
        this.refreshInput();
        this.registerListeners();
        this.setContent();
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.detailsTable.getGrid(), "nebulaGridDetails");
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.labelTitle, "clocksDetailsTitleLabel");
        this.labelTitle.addDisposeListener(e -> this.listeners.forEach(x -> this.guiController.removeModelListener((IEventListener)x)));
    }

    private void registerListeners() {
        this.addConfigUpdateListener();
        this.registerValueChangeListeners();
        this.registerProfileListener();
        this.attachSelectedElementPathListener();
        this.attachSelectionChangeListener();
        this.attachDoubleClickListener();
        this.attachLockChangeListener();
    }

    private void attachDoubleClickListener() {
        this.detailsTable.getGridViewer().addDoubleClickListener(e -> this.setContent());
    }

    private void registerProfileListener() {
        IEventListener listener = e -> this.refreshInput();
        this.guiController.addListener(64, listener);
        this.listeners.add(listener);
    }

    private void attachLockChangeListener() {
        IEventListener listener = event -> {
            if (event.originator != this.detailsTable.getGrid()) {
                Object object = event.object;
                if (object instanceof ISetting) {
                    this.detailsTable.refreshSetting((ISetting)object);
                } else {
                    this.detailsTable.refresh();
                }
            }
        };
        this.guiController.addListener(16, listener);
        this.listeners.add(listener);
    }

    private void attachSelectionChangeListener() {
        ISelectionChangedListener tableSelectionListenerLoc;
        this.tableSelectionListener = tableSelectionListenerLoc = event -> {
            this.detailsTable.clearHighlight();
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof ISettingNode) {
                        ISettingNode settingNode = (ISettingNode)object;
                        this.detailsTable.addHighlight(settingNode.getId());
                        IElement element = SettingEditorHelper.getElement(settingNode);
                        if (element != null) {
                            this.guiController.setSelectedElement(element.getID(), this.detailsTable.getGrid());
                            this.openClockSliceDialog(element.getID());
                        }
                    }
                    ++n2;
                }
            }
            if (!this.detailsTable.getGridViewer().isCellEditorActive()) {
                this.detailsTable.refresh();
            }
        };
        this.detailsTable.getGridViewer().addSelectionChangedListener(tableSelectionListenerLoc);
    }

    private void openClockSliceDialog(String elementId) {
        this.guiController.getProfile().getMcu().getClockComponents().values().stream().flatMap(cc -> cc.getSlices().stream()).forEach(s -> {
            if (s.getElements().containsKey(elementId)) {
                SliceDiagramDialog.getFor(s, GuiController.getActiveShell()).open();
            }
        });
    }

    private void attachSelectedElementPathListener() {
        IEventListener listener = event -> {
            if (event.originator == this.detailsTable.getGrid()) {
                return;
            }
            this.setContent();
        };
        this.listeners.add(listener);
        this.guiController.addListener(12, listener);
    }

    private void setContent() {
        this.detailsTable.getGridViewer().removeSelectionChangedListener(this.tableSelectionListener);
        String contentIDLoc = this.contentID = this.guiController.getSelectedElement();
        String idToSelect = null;
        this.detailsTable.clearHighlight();
        if (contentIDLoc != null) {
            IMcu selectedMcu = this.guiController.getProfile().getMcu();
            IClockElement selectedElement = selectedMcu.getClockElement(contentIDLoc);
            if (selectedElement != null) {
                ISetting mainSetting = selectedElement.getMainSetting();
                idToSelect = mainSetting != null ? mainSetting.getId() : selectedElement.getID();
                this.detailsTable.addHighlight(idToSelect);
            } else {
                IConfigElement configElement = (IConfigElement)CollectionsUtils.findAny(selectedMcu.getAllGlobalConfigElements(), x -> x.getID().equals(contentIDLoc));
                if (configElement != null) {
                    idToSelect = configElement.getID();
                    this.detailsTable.addHighlight(idToSelect);
                }
            }
        }
        this.refreshTitle();
        this.refreshInput();
        if (idToSelect != null) {
            this.detailsTable.setSelectedNodes(CollectionsUtils.asList(idToSelect));
        }
        this.detailsTable.getGridViewer().addSelectionChangedListener(this.tableSelectionListener);
    }

    void refreshTitle() {
        String activeElement = this.contentID;
        String title = Messages.get().DetailsWindow_ProcessorDetailsTitle;
        IMcu mcu = this.guiController.getProfile().getMcu();
        if (activeElement != null) {
            IClockElement clockElement = mcu.getClockElement(activeElement);
            if (clockElement != null) {
                title = clockElement instanceof ClockOutput ? MessageFormat.format(Messages.get().DetailsWindow_PathDetailsTitle, activeElement) : MessageFormat.format(Messages.get().DetailsWindow_ElementDetailsTitle, activeElement);
            } else {
                IClockComponent clockComponent = mcu.getClockComponent(activeElement);
                if (clockComponent != null) {
                    title = MessageFormat.format(Messages.get().DetailsWindow_ComponentDetailsTitle, activeElement);
                }
            }
        }
        this.labelTitle.setText(title);
    }

    public void refreshInput() {
        IClocksConfig activeConfig = this.guiController.getProfile().getActiveConfig();
        SettingsInput settings = this.guiController.createSettingsInput(this.contentID, false);
        if (activeConfig != null) {
            settings.removeSettings(this.settingsFilter);
            this.detailsTable.setInput(settings);
        } else {
            this.detailsTable.setInput(new SettingsInput(new ArrayList<ISettingNode>()));
        }
    }

    private void registerValueChangeListeners() {
        IEventListener listener = e -> this.refreshInput();
        this.guiController.addListener(34, listener);
        this.listeners.add(listener);
        DetailsWindow.addValueChangeListener(this.detailsTable);
    }

    public void setFilter(@NonNull SettingsFilter filter) {
        this.settingsFilter = filter;
    }

    private static void addValueChangeListener(@NonNull SettingsTable table) {
        table.setValueChangeListener(new SettingValueChangeListener(table.getGrid()));
    }

    private void addConfigUpdateListener() {
        IEventListener listener = e -> {
            IClocksConfig activeConfig = this.guiController.getProfile().getActiveConfig();
            if (activeConfig != null) {
                this.settingsFilter.updateConfig(activeConfig);
            }
        };
        this.guiController.addListener(96, listener);
        this.listeners.add(listener);
    }
}

