/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.clock.modules.InputSignal;
import com.nxp.swtools.expert.clock.modules.PeripheralComponent;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.expert.clock.modules.PeripheralInstance;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class ModuleClocksWindow {
    private static final int AUTO_EXPAND_LEVEL = 3;
    private static final double COLUMN_WIDTH_COEFFICIENT = 1.25;
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(ModuleClocksWindow.class);
    @NonNull
    final Tree tree;
    @NonNull
    final TreeViewer treeViewer;
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();

    public ModuleClocksWindow(@NonNull Composite parent) {
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.tree = ModuleClocksWindow.createPeripheralTree(parent);
        this.treeViewer = this.createPeripheralsTreeViewer();
        this.registerListeners();
        this.refreshInput();
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)this.treeViewer);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.tree, "moduleClocksTable");
    }

    private void registerListeners() {
        IEventListener reloadListener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                ModuleClocksWindow.this.refreshInput();
                ModuleClocksWindow.this.refreshColumnLayout();
            }
        };
        GuiController.getInstance().addListener(64, reloadListener);
        IEventListener refreshListener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                ModuleClocksWindow.this.treeViewer.refresh();
                ModuleClocksWindow.this.refreshColumnLayout();
            }
        };
        GuiController.getInstance().addListener(34, refreshListener);
        this.tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ModuleClocksWindow.this.listeners.forEach(x -> GuiController.getInstance().removeModelListener((IEventListener)x));
            }
        });
        this.listeners.add(reloadListener);
        this.listeners.add(refreshListener);
    }

    private @NonNull TreeViewer createPeripheralsTreeViewer() {
        TreeViewer periphsTreeViewer = new TreeViewer(this.tree);
        periphsTreeViewer.setContentProvider((IContentProvider)ModuleClocksWindow.createTreeContentProvider());
        periphsTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ModuleClocksWindow.createColumns(periphsTreeViewer);
        periphsTreeViewer.setAutoExpandLevel(3);
        return periphsTreeViewer;
    }

    private static void createColumns(TreeViewer periphsTreeViewer) {
        TreeViewerColumn peripheralColumn = new TreeViewerColumn(periphsTreeViewer, 0);
        peripheralColumn.getColumn().setText(Messages.get().ModuleClocksWindow_PeripheralColumn);
        peripheralColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof InputSignal) {
                    cell.setText(((InputSignal)element).getDescription());
                } else if (element instanceof PeripheralInstance) {
                    cell.setText(((PeripheralInstance)element).getName());
                } else if (element instanceof PeripheralInstance.Input) {
                    cell.setText(((PeripheralInstance.Input)element).getSignal());
                } else {
                    cell.setText(element.toString());
                }
            }

            public String getToolTipText(Object element) {
                return ModuleClocksWindow.createToolTip(element);
            }
        });
        TreeViewerColumn consumerColumn = new TreeViewerColumn(periphsTreeViewer, 0);
        consumerColumn.getColumn().setText(Messages.get().ModuleClocksWindow_ConsumedClocksColumn);
        consumerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof InputSignal) {
                    cell.setText(((InputSignal)element).getSignal());
                } else if (element instanceof PeripheralInstance.Input) {
                    cell.setText(((PeripheralInstance.Input)element).getSignal());
                } else {
                    cell.setText("");
                }
            }

            public String getToolTipText(Object element) {
                return ModuleClocksWindow.createToolTip(element);
            }
        });
        TreeViewerColumn freqColumn = new TreeViewerColumn(periphsTreeViewer, 0);
        freqColumn.getColumn().setText(Messages.get().ModuleClocksWindow_ColumnFrequency);
        freqColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof InputSignal) {
                    this.updateFrequency(cell, ((InputSignal)element).getSignal());
                } else if (element instanceof PeripheralInstance.Input) {
                    this.updateFrequency(cell, ((PeripheralInstance.Input)element).getSignal());
                } else {
                    cell.setText("");
                }
            }

            public String getToolTipText(Object element) {
                Object value;
                String elementID = "";
                if (element instanceof InputSignal) {
                    elementID = ((InputSignal)element).getSignal();
                } else if (element instanceof PeripheralInstance.Input) {
                    elementID = ((PeripheralInstance.Input)element).getSignal();
                }
                GuiController controller = GuiController.getInstance();
                IClockElement clockElement = controller.getClockElementById(elementID);
                IClocksConfig activeConfig = controller.getProfile().getActiveConfig();
                if (clockElement != null && activeConfig != null && (value = activeConfig.getSettingsConfig().getSettingValue(clockElement.getOutputFrequencySetting()).getValue()) instanceof Frequency) {
                    return ((Frequency)value).toExactString();
                }
                return ModuleClocksWindow.createToolTip(element);
            }

            private void updateFrequency(@NonNull ViewerCell cell, @NonNull String input) {
                GuiController controller = GuiController.getInstance();
                IClockElement clockElement = controller.getClockElementById(input);
                IClocksConfig activeConfig = controller.getProfile().getActiveConfig();
                if (clockElement != null && activeConfig != null) {
                    SettingValue settingValue = activeConfig.getSettingsConfig().getSettingValue(clockElement.getOutputFrequencySetting());
                    cell.setText(settingValue.getUiValue());
                    if (settingValue.isN_A()) {
                        cell.setForeground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_FG"));
                    } else {
                        cell.setForeground(null);
                    }
                }
            }
        });
    }

    private static @NonNull ITreeContentProvider createTreeContentProvider() {
        return new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof PeripheralComponent) {
                    PeripheralComponent component = (PeripheralComponent)element;
                    return !component.getInputSignals().isEmpty();
                }
                if (element instanceof PeripheralInstance) {
                    PeripheralInstance instance = (PeripheralInstance)element;
                    return !instance.getInputs().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof PeripheralComponent) {
                    PeripheralComponent component = (PeripheralComponent)parentElement;
                    return component.getInputSignals().toArray();
                }
                if (parentElement instanceof PeripheralInstance) {
                    PeripheralInstance instance = (PeripheralInstance)parentElement;
                    return instance.getInputs().toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private static @NonNull Tree createPeripheralTree(Composite parent) {
        final Tree periphsTree = new Tree(parent, 66308);
        periphsTree.setLinesVisible(true);
        periphsTree.setHeaderVisible(true);
        periphsTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == null) {
                    return;
                }
                Object item = e.item.getData();
                if (item instanceof InputSignal) {
                    GuiController.getInstance().setSelectedElement(((InputSignal)item).getSignal(), periphsTree);
                }
            }
        });
        return periphsTree;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void refreshInput() {
        IMcu mcu = GuiController.getInstance().getProfile().getMcu();
        PeripheralComponentFile componentFile = mcu.getPeripheralComponentFile();
        if (componentFile.isLegacy()) {
            this.treeViewer.setInput((Object)componentFile.getPeriphInstances().toArray());
        } else {
            @NonNull List peripherals = componentFile.getPeriphComponents();
            this.treeViewer.setInput((Object)peripherals.toArray());
        }
        TreeColumn[] treeColumnArray = this.tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    static @Nullable String createToolTip(@Nullable Object element) {
        StringJoiner tooltipJoiner = new StringJoiner("<br/><br/>");
        if (element instanceof PeripheralInstance) {
            PeripheralInstance instance = (PeripheralInstance)element;
            tooltipJoiner.add(instance.getName());
        } else if (element instanceof PeripheralComponent) {
            PeripheralComponent component = (PeripheralComponent)element;
            component.getInputSignals().forEach(x -> tooltipJoiner.add(String.valueOf(UtilsText.htmlB((String)x.getSignal())) + "<br/>" + UtilsText.htmlB((String)Messages.get().ModuleClocksWindow_Description) + x.getDescription()));
        }
        return tooltipJoiner.toString().isEmpty() ? null : tooltipJoiner.toString();
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    void refreshColumnLayout() {
        int columnCount = this.tree.getColumnCount();
        int maxWidth = this.tree.getSize().x;
        int[] columnWidths = new int[columnCount];
        int equalLimit = maxWidth / columnCount;
        int sumWidth = 0;
        int i = 0;
        while (i < columnCount) {
            TreeColumn column = this.tree.getColumn(i);
            column.pack();
            columnWidths[i] = column.getWidth();
            sumWidth += column.getWidth();
            ++i;
        }
        if (sumWidth < maxWidth) {
            double multiplier = 1.0;
            if ((double)sumWidth * 1.25 < (double)maxWidth) {
                multiplier = 1.25;
            }
            int i2 = 0;
            while (i2 < columnCount) {
                this.tree.getColumn(i2).setWidth((int)((double)columnWidths[i2] * multiplier));
                ++i2;
            }
        } else {
            int extraSpace = 0;
            int tooBigColumns = 0;
            int i3 = 0;
            while (i3 < columnCount) {
                if (columnWidths[i3] <= equalLimit) {
                    extraSpace += equalLimit - columnWidths[i3];
                } else {
                    ++tooBigColumns;
                }
                ++i3;
            }
            int extraSpacePerBigColumns = extraSpace / (tooBigColumns != 0 ? tooBigColumns : 1);
            int i4 = 0;
            while (i4 < columnCount) {
                if (columnWidths[i4] > equalLimit) {
                    columnWidths[i4] = equalLimit + extraSpacePerBigColumns;
                }
                this.tree.getColumn(i4).setWidth(columnWidths[i4]);
                ++i4;
            }
        }
    }
}

