/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagram;

import com.nxp.swtools.clocks.data.ClockSlice;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.ui.diagram.DiagramCanvas;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.utils.events.IEventListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SliceDiagramDialog
extends Dialog {
    @NonNull
    private ClockSlice slice;
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();

    public static @NonNull SliceDiagramDialog getFor(@NonNull ClockSlice slice, @NonNull Shell parentShell) {
        SliceDiagramDialog dialog = GuiController.getInstance().getSlicesDialogHolder().get(slice.getID());
        if (dialog == null) {
            dialog = new SliceDiagramDialog(parentShell, slice);
        }
        return dialog;
    }

    public SliceDiagramDialog(@NonNull Shell parentShell, @NonNull ClockSlice slice) {
        super(parentShell);
        this.slice = slice;
        GuiController.getInstance().getSlicesDialogHolder().put(slice.getID(), this);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(this.slice.getName());
        Composite configComposite = new Composite(parent, 2048);
        configComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        configComposite.setLayout((Layout)new FillLayout());
        IMcu mcu = GuiController.getInstance().getProfile().getMcu();
        DiagramCanvas canvas = new DiagramCanvas(configComposite, this.slice.getDiagramData(mcu), null, false);
        parent.addListener(11, event -> canvas.moveAndFillDiagram(false));
        IEventListener changeListener = e -> {
            boolean bl = this.close();
        };
        GuiController.getInstance().addListener(608, changeListener);
        this.listeners.add(changeListener);
        if (Rap.isActive()) {
            canvas.calculateDiagramBB();
            UIJobHelper.runUIJobSystem(() -> canvas.moveAndFillDiagram(false), (Display)Display.getCurrent());
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    protected Point getInitialSize() {
        return new Point(640, 240);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean close() {
        Display display = Display.getCurrent();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IEventListener listener : SliceDiagramDialog.this.listeners) {
                        GuiController.getInstance().removeModelListener(listener);
                    }
                }
            });
        }
        GuiController.getInstance().getSlicesDialogHolder().remove(this.slice.getID());
        return super.close();
    }
}

