/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.StringPool;
import java.text.MessageFormat;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.RGB;

public class Color {
    public final int r;
    public final int g;
    public final int b;
    @NonNull
    private String colorRegistryKey;

    public Color(int r, int g, int b) {
        this(r, g, b, MessageFormat.format("{0}R{1}G{2}B{3}", Color.class.getCanonicalName(), Integer.toString(r), Integer.toString(g), Integer.toString(b)));
    }

    private Color(int r, int g, int b, @NonNull String colorRegistryKey) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.colorRegistryKey = StringPool.intern((String)colorRegistryKey);
    }

    public @NonNull org.eclipse.swt.graphics.Color getSWTColor() {
        ColorRegistry colorReg = JFaceResources.getColorRegistry();
        if (!colorReg.hasValueFor(this.colorRegistryKey)) {
            colorReg.put(this.colorRegistryKey, new RGB(this.r, this.g, this.b));
        }
        org.eclipse.swt.graphics.Color color = colorReg.get(this.colorRegistryKey);
        assert (color != null);
        return color;
    }

    public @NonNull Color makeCopy() {
        return new Color(this.r, this.g, this.b, this.colorRegistryKey);
    }
}

