/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagramsymbols.BoundingBox;
import com.nxp.swtools.clocks.ui.diagramsymbols.CompositeSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.HitInfo;
import com.nxp.swtools.clocks.ui.diagramsymbols.ICollidable;
import com.nxp.swtools.clocks.ui.diagramsymbols.IDrawable;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.PinConnection;
import com.nxp.swtools.clocks.ui.diagramsymbols.Text;
import com.nxp.swtools.clocks.ui.diagramsymbols.TextField;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public abstract class DiagramSymbol
implements ICollidable,
IDrawable {
    private static final double BB_HIT_TOLERANCE = 0.25;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DiagramSymbol.class);
    @NonNull
    protected BoundingBox mBoundingBoxDS;
    protected static Comparator<@Nullable GraphicalElement> mGraphElemTextComparator = (e1, e2) -> {
        boolean isE1TextField = e1 instanceof TextField;
        boolean isE2TextField = e2 instanceof TextField;
        if (!isE1TextField && isE2TextField) {
            return -1;
        }
        if (isE1TextField && !isE2TextField) {
            return 1;
        }
        return 0;
    };
    protected static Comparator<@Nullable GraphicalElement> mGraphElemPinConnComparator = (e1, e2) -> {
        boolean isE1PinConn = e1 instanceof PinConnection;
        boolean isE2PinConn = e2 instanceof PinConnection;
        if (!isE1PinConn && isE2PinConn) {
            return -1;
        }
        if (isE1PinConn && !isE2PinConn) {
            return 1;
        }
        return 0;
    };
    @NonNull
    protected String mId;
    @NonNull
    protected @NonNull List<@NonNull GraphicalElement> mGraphElems;
    @Nullable
    protected TextField mOutputFreq;
    @Nullable
    protected TextField mCmuFreq;
    @Nullable
    protected TextField mScale;
    @Nullable
    protected CompositeSymbol mParent;
    protected final boolean mIsDiagramOnly;
    @Nullable
    protected PinConnection mPinConnection;

    public DiagramSymbol(@NonNull String id, boolean isDiagramOnly) {
        this.mId = id;
        this.mGraphElems = new ArrayList<GraphicalElement>();
        this.mBoundingBoxDS = new BoundingBox();
        this.mIsDiagramOnly = isDiagramOnly;
    }

    public @NonNull String getId() {
        return this.mParent != null ? String.valueOf(this.mParent.getId()) + '.' + this.mId : this.mId;
    }

    public void setId(@NonNull String id) {
        this.mId = id;
    }

    public void addGraphElem(@NonNull GraphicalElement elem) {
        this.mGraphElems.add(elem);
        if (!(elem instanceof Text)) {
            this.updateBB(elem.getBoundingBoxDS());
        }
        if (elem instanceof PinConnection) {
            assert (this.mPinConnection == null);
            this.mPinConnection = (PinConnection)elem;
        }
        this.mGraphElems.sort(mGraphElemPinConnComparator);
        this.mGraphElems.sort(mGraphElemTextComparator);
    }

    public @NonNull List<@NonNull GraphicalElement> getGraphElems() {
        return this.mGraphElems;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull Text> getAllTexts() {
        @NonNull List result = (List)CollectionsUtils.getInstancesOf(this.mGraphElems, Text.class).collect(CollectorsUtils.toList());
        CollectionsUtils.addIfNonNull((Object)this.mScale, (Collection)result);
        CollectionsUtils.addIfNonNull((Object)this.mOutputFreq, (Collection)result);
        CollectionsUtils.addIfNonNull((Object)this.mCmuFreq, (Collection)result);
        return result;
    }

    public @NonNull BoundingBox getBoundingBoxDS() {
        return this.mBoundingBoxDS;
    }

    public @NonNull BoundingBox calculateMaxBoundingBoxDS() {
        BoundingBox box = new BoundingBox();
        for (GraphicalElement e : this.mGraphElems) {
            box = box.merge(e.getBoundingBoxDS());
        }
        if (this.mOutputFreq != null) {
            box = box.merge(this.mOutputFreq.getBoundingBoxDS());
        }
        if (this.mScale != null) {
            box = box.merge(this.mScale.getBoundingBoxDS());
        }
        if (this.mCmuFreq != null) {
            box.merge(this.mCmuFreq.getBoundingBoxDS());
        }
        return box;
    }

    public @Nullable HitInfo computeHitInfo(@NonNull Point2D p) {
        TextField t = this.mOutputFreq;
        HitInfo result = this.getHitInfo(t, p, HitInfo.HitType.OUTPUT_FREQ);
        if (result == null && t != null) {
            result = this.getHitInfo(t.getLock(), p, HitInfo.HitType.OUTPUT_FREQ_LOCK);
        }
        if (result == null && (result = this.getHitInfo(t = this.mScale, p, HitInfo.HitType.SCALE)) == null && t != null) {
            result = this.getHitInfo(t.getLock(), p, HitInfo.HitType.SCALE_LOCK);
        }
        if (result == null) {
            result = this.mGraphElems.stream().filter(x -> x instanceof Pin).map(x -> this.isPinBoundingBoxHited(p, (GraphicalElement)x, 0.25)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (result == null) {
            result = this.mGraphElems.stream().map(x -> this.getHitInfo((GraphicalElement)x, p, HitInfo.HitType.OTHER)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return result;
    }

    private @Nullable HitInfo isPinBoundingBoxHited(@NonNull Point2D point, @NonNull GraphicalElement element, double tolerance) {
        BoundingBox boundingBox = element.getBoundingBoxDS();
        Point2D bottomRight = boundingBox.getBottomRightCornerDS();
        Point2D topLeft = boundingBox.getTopLeftCornerDS();
        double xScale = Math.abs(bottomRight.getX() - topLeft.getX()) * tolerance;
        double yScale = Math.abs(bottomRight.getY() - topLeft.getY()) * tolerance;
        BoundingBox scaledBB = new BoundingBox();
        scaledBB.setBottomRightCorner(bottomRight.getX() + xScale, bottomRight.getY() + yScale);
        scaledBB.setTopLeftCorner(topLeft.getX() - xScale, topLeft.getY() - yScale);
        if (scaledBB.isHitBy(point)) {
            return new HitInfo(this.getId(), element, HitInfo.HitType.BOUNDING_BOX);
        }
        return null;
    }

    private @Nullable HitInfo getHitInfo(@Nullable GraphicalElement element, @NonNull Point2D point, @NonNull HitInfo.HitType type) {
        if (element != null && element.isHitBy(point)) {
            if (this.getId().contains("Clock Slices")) {
                return new HitInfo(this.getId(), element, HitInfo.HitType.SLICE);
            }
            return new HitInfo(this.getId(), element, type);
        }
        return null;
    }

    public void setOutputFrequencyField(@NonNull TextField field) {
        this.mOutputFreq = field;
    }

    public void setCmuFrequencyField(@NonNull TextField field) {
        this.mCmuFreq = field;
    }

    public void setScaleField(@NonNull TextField field) {
        this.mScale = field;
    }

    public boolean updateScale(@NonNull String value, boolean isLocked) {
        TextField field = this.mScale;
        if (field != null) {
            field.updateText(value);
            field.setLock(isLocked);
            return true;
        }
        return false;
    }

    protected void updateBB(@Nullable BoundingBox BB) {
        this.mBoundingBoxDS = this.mBoundingBoxDS.merge(BB);
    }

    public boolean updateOutputFrequency(@NonNull String value, boolean isLocked, @NonNull DrawState.State state) {
        TextField field = this.mOutputFreq;
        if (field != null) {
            field.updateText(value);
            field.setLock(isLocked);
            field.update(state);
            return true;
        }
        return false;
    }

    public boolean updateCmuOutputFrequency(@NonNull String value, boolean isLocked, @NonNull DrawState.State state) {
        TextField field = this.mCmuFreq;
        if (field != null) {
            field.updateText(value);
            field.setLock(isLocked);
            field.update(state);
            return true;
        }
        return false;
    }

    public void updateActivePin(@NonNull DrawState.State state) {
        if (this.mPinConnection != null) {
            this.mPinConnection.update(state);
        }
    }

    public boolean hasOutputFrequency() {
        return this.mOutputFreq != null;
    }

    public boolean hasCmuOutputFrequency() {
        return this.mCmuFreq != null;
    }

    public void update(@NonNull DrawState.State state) {
        boolean selectionChanged = state.equals((Object)DrawState.State.SELECTED_FLAG) || state.equals((Object)DrawState.State.CLEAR);
        this.mGraphElems.stream().filter(x -> selectionChanged || !(x instanceof Pin) || !((Pin)x).isInput()).forEach(x -> x.update(state));
    }

    public boolean hasScale() {
        return this.mScale != null;
    }

    public String toString() {
        return this.getId();
    }

    public void setParent(@Nullable CompositeSymbol parent) {
        this.mParent = parent;
    }

    public @Nullable DiagramSymbol getParent() {
        return this.mParent;
    }

    @Override
    public boolean isHitBy(@NonNull Point2D p) {
        return this.computeHitInfo(p) != null;
    }

    @Override
    public @NonNull List<@NonNull Point2D> getHullPoints() {
        return this.mBoundingBoxDS.getHullPoints();
    }

    public void setActiveInputPin(@Nullable Pin pin) {
        if (this.mPinConnection != null) {
            this.mPinConnection.setInputPin(pin);
            assert (pin == null || this.mGraphElems.contains(pin));
        }
    }

    public @Nullable Pin getActiveInputPin() {
        PinConnection locPinConnection = this.mPinConnection;
        return locPinConnection != null ? locPinConnection.mInputPin : null;
    }

    public boolean isDiagramOnly() {
        return this.mIsDiagramOnly;
    }

    public @NonNull List<@NonNull Point2D> getGraphElemPosition(@NonNull HitInfo.HitType type) {
        ArrayList<@NonNull Point2D> result = new ArrayList<Point2D>();
        switch (type) {
            case OUTPUT_FREQ_LOCK: {
                if (this.mOutputFreq == null) break;
                CollectionsUtils.addIfNonNull((Object)this.mOutputFreq.getLock().getCenter(), result);
                break;
            }
            case OUTPUT_FREQ: {
                if (this.mOutputFreq == null) break;
                CollectionsUtils.addIfNonNull((Object)this.mOutputFreq.getCenter(), result);
                break;
            }
            case SCALE_LOCK: {
                if (this.mScale == null) break;
                CollectionsUtils.addIfNonNull((Object)this.mScale.getLock().getCenter(), result);
                break;
            }
            case SCALE: {
                if (this.mScale == null) break;
                CollectionsUtils.addIfNonNull((Object)this.mScale.getCenter(), result);
                break;
            }
            case BOUNDING_BOX: 
            case SLICE: {
                CollectionsUtils.addIfNonNull((Object)this.mBoundingBoxDS.getCenterDS(), result);
                break;
            }
            case OTHER: {
                this.mGraphElems.forEach(x -> {
                    boolean bl = CollectionsUtils.addIfNonNull((Object)x.getCenter(), (Collection)result);
                });
                break;
            }
            default: {
                LOGGER.severe("Querying hitType: " + (Object)((Object)type) + ", which is not supported.");
                assert (false);
                break;
            }
        }
        return result;
    }

    public void setDisplayName(@NonNull String name) {
        for (GraphicalElement element : this.mGraphElems) {
            TextField textField;
            if (!(element instanceof TextField) || !"Ref".equals((textField = (TextField)element).getId()) && !"Element_name".equals(textField.getId())) continue;
            textField.mText = name;
            break;
        }
    }

    public abstract @NonNull DiagramSymbol makeCopy();

    public static enum Orientation {
        NORMAL,
        ROT_DOWN_MIRROR,
        ROT_LEFT_MIRROR,
        ROT_RIGHT,
        MIRROR,
        ROT_DOWN,
        ROT_LEFT,
        ROT_RIGHT_MIRROR;

    }
}

