/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagram.Style;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.common.utils.NonNull;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.events.PaintEvent;

public class Lock
extends GraphicalElement {
    @NonNull
    protected Point2D mPositionDS;
    protected double mWidth = 8.0;
    protected double mArcOffset = 0.75;

    public Lock(@NonNull Point2D bottomLeftCorner_DS, double width) {
        this.mPositionDS = bottomLeftCorner_DS;
        this.mWidth = width;
        this.calculateBB();
    }

    @Override
    public void draw(@NonNull AffineTransform transform, @NonNull PaintEvent e, DiagramStyleProvider styleProvider) {
        double offset_DC = this.mArcOffset * this.mWidth;
        Point2D.Double rect_TLC_DS = new Point2D.Double(this.mPositionDS.getX(), this.mPositionDS.getY() - this.mWidth);
        Point2D rect_TLC_CS = transform.transform(rect_TLC_DS, null);
        Point2D.Double arc_TLC_DS = new Point2D.Double(((Point2D)rect_TLC_DS).getX(), ((Point2D)rect_TLC_DS).getY() - offset_DC);
        Point2D arc_TLC_CS = transform.transform(arc_TLC_DS, null);
        int width_CS = (int)(transform.getScaleX() * this.mWidth);
        int lineEndY = (int)arc_TLC_CS.getY() + width_CS / 2;
        Style style = styleProvider.getStyle(this, this.mDrawState);
        style.Fill.set(e);
        style.LineStyle.set(e);
        e.gc.drawArc((int)arc_TLC_CS.getX(), (int)arc_TLC_CS.getY(), width_CS, width_CS, 0, 180);
        e.gc.fillRectangle((int)rect_TLC_CS.getX(), (int)rect_TLC_CS.getY(), width_CS, width_CS);
        e.gc.drawRectangle((int)rect_TLC_CS.getX(), (int)rect_TLC_CS.getY(), width_CS, width_CS);
        e.gc.drawLine((int)rect_TLC_CS.getX(), (int)rect_TLC_CS.getY(), (int)rect_TLC_CS.getX(), lineEndY);
        e.gc.drawLine((int)rect_TLC_CS.getX() + width_CS, (int)rect_TLC_CS.getY(), (int)rect_TLC_CS.getX() + width_CS, lineEndY);
        style.LineStyle.unset(e);
        style.Fill.unset(e);
    }

    @Override
    protected @NonNull GraphicalElement makeCopy() {
        return new Lock(new Point2D.Double(this.mPositionDS.getX(), this.mPositionDS.getY()), this.mWidth);
    }

    @Override
    public void applyTransform(@NonNull AffineTransform transformDS) {
        transformDS.transform(this.mPositionDS, this.mPositionDS);
        this.calculateBB();
    }

    protected void calculateBB() {
        this.mBoundingBoxDS.setTopLeftCorner(this.mPositionDS.getX(), this.mPositionDS.getY() - this.mArcOffset * this.mWidth - this.mWidth);
        this.mBoundingBoxDS.setBottomRightCorner(this.mPositionDS.getX() + this.mWidth, this.mPositionDS.getY());
    }
}

