/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagram.Style;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.common.utils.NonNull;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.events.PaintEvent;

public class Rectangle
extends GraphicalElement {
    public Rectangle(@NonNull Point2D topLeftCornerDS, @NonNull Point2D bottomRightCornerDS) {
        this.mBoundingBoxDS.setTopLeftCorner(topLeftCornerDS);
        this.mBoundingBoxDS.setBottomRightCorner(bottomRightCornerDS);
        this.mBoundingBoxDS.orderCorners();
    }

    @Override
    public Rectangle makeCopy() {
        Point2D tlc = (Point2D)this.mBoundingBoxDS.getTopLeftCornerDS().clone();
        Point2D brc = (Point2D)this.mBoundingBoxDS.getBottomRightCornerDS().clone();
        assert (tlc != null);
        assert (brc != null);
        return new Rectangle(tlc, brc);
    }

    @Override
    public void applyTransform(AffineTransform transformDS) {
        transformDS.transform(this.mBoundingBoxDS.getTopLeftCornerDS(), this.mBoundingBoxDS.getTopLeftCornerDS());
        transformDS.transform(this.mBoundingBoxDS.getBottomRightCornerDS(), this.mBoundingBoxDS.getBottomRightCornerDS());
        this.mBoundingBoxDS.orderCorners();
    }

    @Override
    public void draw(AffineTransform transform, PaintEvent e, DiagramStyleProvider styleProvider) {
        Style style = styleProvider.getStyle(this, this.mDrawState);
        this.mBoundingBoxDS.draw(transform, e, style.Fill, style.LineStyle);
    }

    @Override
    public boolean isHitBy(Point2D p) {
        return this.mBoundingBoxDS.isHitBy(p);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.mBoundingBoxDS.getTopLeftCornerDS() + ", " + this.mBoundingBoxDS.getBottomRightCornerDS() + "]";
    }
}

