/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.table;

import com.nxp.swtools.clocks.platform.PlatformSpecificFactory;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.os.OSDetect;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxAdvanced
extends ComboBoxCellEditor {
    private static final int VISIBLE_COUNT = Rap.isActive() ? 6 : 12;
    protected boolean scrolledOrTraverseEvent = false;
    @Nullable
    Object initialValueMinusOne;
    private boolean firstTime = true;

    public ComboBoxAdvanced(@NonNull Grid table, @NonNull String[] values, int style) {
        super((Composite)table, values, style);
        this.setActivationStyle(1);
    }

    public ComboBoxAdvanced(@NonNull Grid table, String @NonNull [] values) {
        super((Composite)table, values);
        this.setActivationStyle(1);
    }

    protected Control createControl(Composite parent) {
        Control comboControl = super.createControl(parent);
        if (comboControl instanceof CCombo) {
            CCombo combo = (CCombo)comboControl;
            combo.setVisibleItemCount(VISIBLE_COUNT);
            SWTFactoryProxy.INSTANCE.createMouseWheelListener(event -> this.setScrolledOrTraverseEventToTrue(), (Control)combo);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ComboBoxAdvanced.this.scrolledOrTraverseEvent) {
                        ComboBoxAdvanced.this.scrolledOrTraverseEvent = false;
                        return;
                    }
                    if (OSDetect.isUnix()) {
                        if (ComboBoxAdvanced.this.initialValueMinusOne instanceof Integer && (Integer)ComboBoxAdvanced.this.initialValueMinusOne == -1) {
                            ComboBoxAdvanced.this.initialValueMinusOne = null;
                        } else {
                            ComboBoxAdvanced.this.lostFocus();
                        }
                    } else {
                        ComboBoxAdvanced.this.lostFocus();
                    }
                }
            });
            combo.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                    if (!(Rap.isActive() || e.detail != PlatformSpecificFactory.getPlatformSpecific().getSwtConstantTraverseArrowPrevious() && e.detail != PlatformSpecificFactory.getPlatformSpecific().getSwtConstantTraverseArrowNext())) {
                        ComboBoxAdvanced.this.scrolledOrTraverseEvent = true;
                        e.doit = false;
                    }
                }
            });
        }
        return comboControl;
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            return;
        }
        super.doSetValue(value);
        if (this.firstTime) {
            this.initialValueMinusOne = value;
            this.firstTime = false;
        }
    }

    void lostFocus() {
        this.focusLost();
    }

    public void setScrolledOrTraverseEventToTrue() {
        this.scrolledOrTraverseEvent = true;
    }
}

