/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.table;

import com.nxp.swtools.clocks.data.ClockSlice;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.clocks.ui.table.SettingNode;
import com.nxp.swtools.clocks.ui.table.SettingsFilter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SettingsInput {
    @NonNull
    private @NonNull List<@NonNull ISettingNode> roots;

    public SettingsInput(@NonNull Collection<@NonNull ISettingNode> settings) {
        this.roots = new ArrayList<ISettingNode>(settings);
    }

    public SettingsInput(@NonNull Map<String, Collection<ISetting>> settings) {
        this.roots = new ArrayList<ISettingNode>();
        for (Map.Entry<String, Collection<ISetting>> entry : settings.entrySet()) {
            String group = entry.getKey();
            Collection<ISetting> groupSettingsCollection = entry.getValue();
            assert (group != null && groupSettingsCollection != null);
            ISettingNode[] groupSettings = SettingsInput.toSettingNodes(groupSettingsCollection);
            SettingNode settingGroup = new SettingNode(group, groupSettings);
            ISettingNode[] iSettingNodeArray = groupSettings;
            int n = groupSettings.length;
            int n2 = 0;
            while (n2 < n) {
                ISettingNode settingRow = iSettingNodeArray[n2];
                settingRow.setParent(settingGroup);
                ++n2;
            }
            this.roots.add(settingGroup);
        }
    }

    public SettingsInput() {
        this.roots = new ArrayList<ISettingNode>();
    }

    public boolean isIdentical(SettingsInput other) {
        if (this.roots.size() != other.roots.size()) {
            return false;
        }
        int i = 0;
        while (i < this.roots.size()) {
            if (!this.roots.get(i).isIdentical(other.roots.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public @NonNull ISettingNode @NonNull [] getAllNodes() {
        ArrayList<@NonNull ISettingNode> nodes = new ArrayList<ISettingNode>(this.roots);
        for (ISettingNode root : this.roots) {
            SettingsInput.addSubNodes(root, nodes);
        }
        return SettingsInput.toArray(nodes);
    }

    private static void addSubNodes(@NonNull ISettingNode node, @NonNull List<@NonNull ISettingNode> list) {
        @NonNull ISettingNode[] children = node.getChildren();
        if (children != null) {
            ISettingNode[] iSettingNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISettingNode child = iSettingNodeArray[n2];
                list.add(child);
                SettingsInput.addSubNodes(child, list);
                ++n2;
            }
        }
    }

    public static @NonNull SettingsInput fromSettings(@NonNull Collection<@NonNull ISetting> settings) {
        SettingsInput input = new SettingsInput();
        input.roots = new ArrayList<ISettingNode>();
        for (ISetting setting : settings) {
            SettingNode settingRow = new SettingNode(setting, new ISettingNode[0]);
            input.roots.add(settingRow);
        }
        return input;
    }

    public static @NonNull SettingsInput fromElement(@NonNull IClockElement element, @NonNull IClocksConfig config) {
        SettingsInput input = SettingsInput.fromElements(Arrays.asList(element), config);
        SettingsInput.appendManageCounterSetting(input, element, config);
        return input;
    }

    public static @NonNull SettingsInput fromComponent(@NonNull IClockComponent component, @NonNull IClocksConfig config) {
        SettingsInput result = SettingsInput.fromElements(component.getElements(), config);
        SettingsInput.addGlobalSettings(result, component.getGlobalConfigElements(), config, false);
        component.getSlices().forEach(x -> SettingsInput.addSliceNode(result, config, x));
        return result;
    }

    private static void addGlobalSettings(@NonNull SettingsInput input, @NonNull Collection<@NonNull IConfigElement> globalConfigElements, @NonNull IClocksConfig config, boolean strict) {
        ArrayList<@NonNull SettingNode> nodes = new ArrayList<SettingNode>();
        HashSet<@NonNull IConfigElement> usedElements = new HashSet<IConfigElement>();
        for (IConfigElement element : globalConfigElements) {
            if (usedElements.contains(element) || strict && element.isComponentOnly()) continue;
            SettingNode node = null;
            SettingNode.Builder builder = new SettingNode.Builder(element.getSetting());
            if (element.getParent() != null) continue;
            if (!element.getPowerModeSpecificSettings().isEmpty()) {
                SettingNode pmNode = SettingsInput.createPowerModeSpecificNode(config, element.getPowerModeSpecificSettings());
                builder.addChild(pmNode);
            }
            if (!element.getChildren().isEmpty()) {
                node = SettingsInput.createNodesHierarchy(element, usedElements, builder);
            }
            usedElements.add(element);
            nodes.add(node != null ? node : builder.build());
        }
        input.roots.addAll(0, nodes);
    }

    private static @NonNull SettingNode createNodesHierarchy(IConfigElement parent, @NonNull Set<@NonNull IConfigElement> usedElements, SettingNode.Builder builder) {
        List<@NonNull IConfigElement> children = parent.getChildren();
        if (!children.isEmpty()) {
            usedElements.addAll(children);
            children.forEach(childElement -> {
                SettingNode.Builder builder2 = builder.addChild(SettingsInput.createNodesHierarchy(childElement, usedElements, new SettingNode.Builder(childElement.getSetting())));
            });
        }
        return builder.build();
    }

    public static @NonNull SettingsInput fromMcu(@NonNull IClocksConfig config) {
        SettingsInput result = SettingsInput.fromElements(new ArrayList<IClockElement>(config.getMcu().getAllElements().values()), config);
        SettingsInput.appendGlobalSettings(result, config);
        return result;
    }

    public static @NonNull SettingsInput fromPathToElement(@NonNull IClockElement element, @NonNull IClocksConfig config) {
        HashSet<@NonNull IConfigElement> globalElementsOnPath = new HashSet<IConfigElement>();
        List<@NonNull IClockElement> elements = config.getPathToOutput(element.getID());
        elements.forEach(x -> {
            IClockComponent component = x.getParentComponent(config.getMcu());
            if (component != null) {
                globalElementsOnPath.addAll(component.getGlobalConfigElements());
            }
        });
        ArrayList<@NonNull IClockElement> elementsToShow = new ArrayList<IClockElement>(elements);
        Collections.reverse(elementsToShow);
        SettingsInput result = SettingsInput.fromElements(elements, config);
        SettingsInput.addGlobalSettings(result, globalElementsOnPath, config, false);
        return result;
    }

    private static void appendGlobalSettings(@NonNull SettingsInput input, @NonNull IClocksConfig config) {
        IMcu mcu = config.getMcu();
        Collection<@NonNull IConfigElement> globalConfigElements = mcu.getAllGlobalConfigElements();
        globalConfigElements.removeIf(IConfigElement::isHidden);
        SettingsInput.addGlobalSettings(input, globalConfigElements, config, true);
        AGlobalSetting powerModeSetting = mcu.getPowerModeSetting();
        if (powerModeSetting != null) {
            input.addSetting(powerModeSetting, 0);
        }
    }

    private static void appendManageCounterSetting(@NonNull SettingsInput input, @NonNull IClockElement element, @NonNull IClocksConfig config) {
        IConfigElement manageCounter;
        if (element instanceof Prescaler && (manageCounter = ((Prescaler)element).getMasterIfCorrect(config)) != null) {
            input.addSetting(manageCounter.getSetting(), 0);
        }
    }

    public void addSetting(@NonNull ISetting setting, int pos) {
        this.roots.add(pos, new SettingNode(setting, null));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull SettingsInput fromElements(@NonNull Collection<@NonNull IClockElement> elements, @NonNull IClocksConfig config) {
        ArrayList<@NonNull ISettingNode> rootNodes = new ArrayList<ISettingNode>();
        for (IClockElement element : elements) {
            @NonNull List elementSettings = (List)element.getSettings().stream().filter(setting -> setting.isVisible(config)).collect(CollectorsUtils.toList());
            if (elementSettings.isEmpty()) {
                rootNodes.add(new SettingNode.Builder(element.getOutputFrequencySetting()).build());
                continue;
            }
            ISetting frequencyModifier = element.getMainSetting();
            SettingNode.Builder builder = null;
            builder = frequencyModifier != null ? new SettingNode.Builder(frequencyModifier) : new SettingNode.Builder(element.getID());
            for (ISetting setting2 : elementSettings) {
                if (setting2 == frequencyModifier) continue;
                builder.addChild(new SettingNode(setting2, null));
            }
            if (!element.getPowerModeSpecificSettings().isEmpty()) {
                SettingNode node = SettingsInput.createPowerModeSpecificNode(config, element.getPowerModeSpecificSettings());
                builder.addChild(node);
            }
            rootNodes.add(builder.build());
        }
        return new SettingsInput(rootNodes);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull SettingNode createPowerModeSpecificNode(@NonNull IClocksConfig config, @NonNull Collection<@NonNull ISetting> pwerModeSettings) {
        ArrayList<@NonNull SettingNode> settings = new ArrayList<SettingNode>();
        SettingValue currentPowerMode = SettingProvider.getValueBySettingId("powerMode", config.getMcu(), config.getSettingsConfig());
        assert (currentPowerMode != null);
        @NonNull List powerModeSpecific = (List)pwerModeSettings.stream().filter(x -> x.getPowerMode() != null && !Objects.equals(currentPowerMode.getUiValue(), x.getPowerMode())).collect(CollectorsUtils.toList());
        @Nullable Set settingsPowerModes = (Set)powerModeSpecific.stream().map(ISetting::getPowerMode).collect(CollectorsUtils.toSet());
        if (powerModeSpecific.size() == 1) {
            ISetting setting = (ISetting)powerModeSpecific.get(0);
            settings.add(new SettingNode(setting, null));
        } else {
            settingsPowerModes.forEach(pMode -> {
                ArrayList<@NonNull E> arrayNode = new ArrayList();
                powerModeSpecific.forEach(pModeSetting -> {
                    @NonNull String powerMode = pModeSetting.getPowerMode();
                    if (powerMode != null && powerMode.equals(pMode)) {
                        arrayNode.add(new SettingNode((ISetting)pModeSetting, null));
                    }
                });
                if (pMode != null) {
                    settings.add(new SettingNode((String)pMode, (ISettingNode[])arrayNode.toArray(new SettingNode[arrayNode.size()])));
                }
            });
        }
        @NonNull ISettingNode[] settingsArray = settings.toArray(new SettingNode[settings.size()]);
        return new SettingNode(UtilsText.safeString((String)Messages.get().SettingsInput_PowerModeSpecific), settingsArray);
    }

    public @NonNull ISettingNode @NonNull [] getRoots() {
        @NonNull ISettingNode[] result = new ISettingNode[this.roots.size()];
        this.roots.toArray(result);
        return result;
    }

    public int getLength() {
        return this.roots.size();
    }

    public static @NonNull ISettingNode @NonNull [] toArray(@NonNull Collection<@NonNull ISettingNode> collection) {
        @NonNull ISettingNode[] array = new ISettingNode[collection.size()];
        array = collection.toArray(array);
        assert (array != null);
        return array;
    }

    private static @NonNull ISettingNode @NonNull [] toSettingNodes(@NonNull Collection<@NonNull ISetting> collection) {
        @NonNull ISettingNode[] array = new ISettingNode[collection.size()];
        int pos = 0;
        for (ISetting setting : collection) {
            SettingNode settingRow = new SettingNode(setting, new ISettingNode[0]);
            array[pos] = settingRow;
            ++pos;
        }
        return array;
    }

    public void removeSettings(@NonNull SettingsFilter filter) {
        this.roots.removeIf(x -> {
            ISetting setting = x.getSetting();
            if (setting != null) {
                return !filter.testSetting(setting);
            }
            boolean testChild = false;
            ISettingNode[] children = x.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    ISettingNode childNode = children[i];
                    ISetting childSetting = childNode.getSetting();
                    if (childSetting != null) {
                        testChild |= filter.testSetting(childSetting);
                    }
                    ++i;
                }
            }
            return !testChild;
        });
    }

    public static void addSliceNode(@NonNull SettingsInput input, @NonNull IClocksConfig config, @NonNull ClockSlice slice) {
        ArrayList<@NonNull IClockElement> sliceElements = new ArrayList<IClockElement>();
        for (IClockElement element : slice.getElements().values()) {
            if (element == null) continue;
            sliceElements.add(element);
        }
        @NonNull ISettingNode[] sliceNodes = SettingsInput.fromElements(sliceElements, config).getRoots();
        SettingNode sliceRoot = new SettingNode.Builder(slice.getName()).addChildren(new ArrayList<ISettingNode>(Arrays.asList(sliceNodes))).build();
        input.roots.add(sliceRoot);
    }
}

