/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.utils;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.ConfigContext;
import com.nxp.swtools.clocks.expression.DependencyContextWrapper;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.BitFieldVariable;
import com.nxp.swtools.common.utils.expression.IContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExpressionUtils {
    public static @NonNull Collection<@NonNull String> getRelatedSettingIDs(@NonNull Set<@NonNull Expression> expressions, @NonNull IMcu mcu) {
        HashSet<@NonNull String> dependencies = new HashSet<String>();
        for (Expression expr : expressions) {
            dependencies.addAll(ExpressionUtils.getRelatedSettingIDs(expr, mcu));
        }
        return dependencies;
    }

    public static @NonNull Collection<@NonNull String> getRelatedSettingIDs(@NonNull Expression expression, @NonNull IMcu mcu) {
        HashSet<@NonNull String> dependencies = new HashSet<String>(expression.getSettings());
        for (BitFieldVariable bfVar : expression.getBitFields()) {
            String bitFieldId = expression.getContext().getBitFieldId(bfVar.getRegisterName(), bfVar.getBitFieldName());
            SettingProvider.addBitFieldSetting(dependencies, bitFieldId, mcu);
        }
        return dependencies;
    }

    public static @NonNull Collection<@NonNull ISetting> getRelatedSettings(@NonNull Set<@NonNull Expression> expressions, @NonNull IMcu mcu) {
        return ExpressionUtils.getSettingsByIDs(ExpressionUtils.getRelatedSettingIDs(expressions, mcu), mcu);
    }

    public static @NonNull Collection<@NonNull ISetting> getRelatedSettings(@NonNull Expression expression, @NonNull IMcu mcu) {
        return ExpressionUtils.getSettingsByIDs(ExpressionUtils.getRelatedSettingIDs(expression, mcu), mcu);
    }

    public static @NonNull Collection<@NonNull ISetting> getSettingsByIDs(Collection<@NonNull String> settingIDs, @NonNull IMcu mcu) {
        HashSet<@NonNull ISetting> settings = new HashSet<ISetting>();
        for (String settingID : settingIDs) {
            ISetting setting = SettingProvider.getSettingById(settingID, mcu);
            if (setting == null) continue;
            settings.add(setting);
        }
        return settings;
    }

    public static @NonNull DependencyContextWrapper getDependencyContextWrapper(@NonNull Expression expression, @NonNull IClocksConfig config) {
        IContext context = expression.getContext();
        ConfigContext resolutionContext = new ConfigContext(context, config);
        DependencyContextWrapper contextWrapper = new DependencyContextWrapper(resolutionContext);
        return contextWrapper;
    }

    public static @Nullable Expression getCaseExpression(@NonNull ValueMap value, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values) {
        Set<Map.Entry<@NonNull Expression, @NonNull ValueMap>> valueEntries = values.entrySet();
        for (Map.Entry<Expression, ValueMap> valueEntry : valueEntries) {
            if (!Objects.equals(valueEntry.getValue(), value)) continue;
            return valueEntry.getKey();
        }
        return null;
    }

    public static @NonNull Set<@NonNull String> getUsedSettings(@NonNull IClocksConfig config, @Nullable Expression optionalExpr, @NonNull Expression requiredExpr) {
        HashSet<@NonNull String> usedSettings = new HashSet<String>();
        if (optionalExpr != null) {
            DependencyContextWrapper caseContext = ExpressionUtils.getDependencyContextWrapper(optionalExpr, config);
            optionalExpr.resolve(caseContext);
            usedSettings.addAll(caseContext.getAllUsedSettings(config));
        }
        DependencyContextWrapper valueMapContext = ExpressionUtils.getDependencyContextWrapper(requiredExpr, config);
        requiredExpr.resolve(valueMapContext);
        usedSettings.addAll(valueMapContext.getAllUsedSettings(config));
        return usedSettings;
    }

    public static @NonNull Set<@NonNull String> getUsedSettings(@NonNull IClocksConfig config, @Nullable Expression optionalExpr) {
        if (optionalExpr != null) {
            DependencyContextWrapper caseContext = ExpressionUtils.getDependencyContextWrapper(optionalExpr, config);
            optionalExpr.resolve(caseContext);
            return caseContext.getAllUsedSettings(config);
        }
        return Collections.emptySet();
    }

    public static @NonNull Expression createOrDefault(@NonNull String expressionText, @Nullable IContext context) {
        if (!expressionText.isEmpty()) {
            if (context == null) {
                return Expression.create(expressionText);
            }
            return Expression.create(expressionText, context);
        }
        return Expression.EXPRESSION_TRUE;
    }
}

