/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.utils;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.StringTokenizer;

public final class ToolTipFormatter {
    public static final int MAX_LINE_LENGTH = 100;

    public static @NonNull String format(@NonNull String text) {
        return ToolTipFormatter.format(text, 100);
    }

    public static @NonNull String format(@NonNull String text, int maxLineLength) {
        @NonNull CharSequence[] lines = UtilsText.splitLines((String)text, (String)"<br/>");
        int i = 0;
        while (i < lines.length) {
            CharSequence line = lines[i];
            if (((String)line).length() > maxLineLength) {
                line = ToolTipFormatter.splitLine((String)line, maxLineLength);
            }
            lines[i] = line;
            ++i;
        }
        return UtilsText.safeString((String)String.join((CharSequence)"<br/>", lines));
    }

    public static @NonNull String splitLine(@NonNull String line) {
        return ToolTipFormatter.splitLine(line, 100);
    }

    public static @NonNull String splitLine(@NonNull String line, int maxLength) {
        StringBuilder resultBuilder = new StringBuilder();
        String leadingWhiteSpaces = ToolTipFormatter.getLeadingWhiteSpaces(line);
        String lineNoLeadingWS = line.substring(leadingWhiteSpaces.length());
        StringTokenizer tokenizer = new StringTokenizer(lineNoLeadingWS, " \t\r\f", true);
        StringBuilder lineBuilder = new StringBuilder();
        int lineTokens = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextWord = tokenizer.nextToken();
            int lineLength = leadingWhiteSpaces.length() + lineBuilder.length() + nextWord.length();
            if (lineLength > maxLength && lineTokens != 0) {
                String trimmedLine = lineBuilder.toString().trim();
                resultBuilder.append(leadingWhiteSpaces).append(trimmedLine).append("<br/>");
                lineBuilder = new StringBuilder();
                lineTokens = 0;
            }
            if (lineTokens <= 0 && nextWord.trim().isEmpty()) continue;
            lineBuilder.append(nextWord);
            ++lineTokens;
        }
        String trimmedLine = lineBuilder.toString().trim();
        resultBuilder.append(leadingWhiteSpaces).append(trimmedLine);
        return UtilsText.safeString((String)resultBuilder.toString());
    }

    public static @NonNull String getLeadingWhiteSpaces(@NonNull String text) {
        int whiteSpacesIdx = 0;
        while (whiteSpacesIdx < text.length() && text.charAt(whiteSpacesIdx) <= ' ') {
            ++whiteSpacesIdx;
        }
        String result = "";
        if (whiteSpacesIdx > 0) {
            result = UtilsText.safeString((String)text.substring(0, whiteSpacesIdx));
        }
        return result;
    }
}

