/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.framework.Application;
import com.nxp.swtools.framework.ApplicationActionBarAdvisor;
import com.nxp.swtools.framework.KExCmdLine;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.Utils;
import com.nxp.swtools.framework.commands.NewConfigurationCommandHandler;
import com.nxp.swtools.framework.handlers.SwitchToolCommandHandler;
import com.nxp.swtools.framework.ui.newconfig.WizardData;
import com.nxp.swtools.kex.selector.IMcuSelection;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.sourceprovider.ConfigurationSourceProvider;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.controller.shared.SharedController;
import com.nxp.swtools.utils.documentation.DocFactoryProxy;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.wizards.WizardUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.wizards.AbstractExtensionWizardRegistry;
import org.eclipse.ui.services.ISourceProviderService;
import org.osgi.framework.Bundle;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final int INITIAL_VERTICAL_SIZE = 720;
    private static final int INITIAL_HORIZONTAL_SIZE = 1280;
    protected static final int MAX_CONF_NAME_LENGTH = 30;
    @NonNull
    public static final Logger LOGGER = LogManager.getLogger(ApplicationWorkbenchWindowAdvisor.class);
    @Nullable
    private ConfigurationSourceProvider configProvider = null;
    @Nullable
    private ApplicationActionBarAdvisor barAdvisor;

    public ApplicationWorkbenchWindowAdvisor(@Nullable IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        this.barAdvisor = new ApplicationActionBarAdvisor(configurer);
        return this.barAdvisor;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(1280, 720));
        configurer.setShowCoolBar(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowMenuBar(true);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        SWToolsPlatform.setSelectedToolProxy(Application::setSelectedTool);
        Application.initializeAnalytics();
        KExProcessorsProvider.setOffline((boolean)KEPreferences.isOffline());
        KEPreferences.applyProxySettings((KEPreferences.ProxyConfiguration)KEPreferences.getProxyConf());
        this.registerListeners();
        WizardUtils.removeWizardsForCategory((AbstractExtensionWizardRegistry)((AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getExportWizardRegistry()), (String)"org.eclipse.ui.Basic");
        WizardUtils.removeWizardsForCategory((AbstractExtensionWizardRegistry)((AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getImportWizardRegistry()), (String)"org.eclipse.ui.Basic");
        WizardUtils.removeWizardsForCategory((AbstractExtensionWizardRegistry)((AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getExportWizardRegistry()), (String)"org.eclipse.cdt.ui.*");
        WizardUtils.removeWizardsForCategory((AbstractExtensionWizardRegistry)((AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getImportWizardRegistry()), (String)"org.eclipse.cdt.ui.*");
        WizardUtils.removeWizardsForCategory((AbstractExtensionWizardRegistry)((AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getExportWizardRegistry()), (String)"org.eclipse.team.ui.*");
        WizardUtils.removeWizardsForCategory((AbstractExtensionWizardRegistry)((AbstractExtensionWizardRegistry)PlatformUI.getWorkbench().getImportWizardRegistry()), (String)"org.eclipse.team.ui.*");
        if (!Rap.isActive()) {
            UserLogger.getInstance().info(MessageFormat.format(Messages.get().ApplicationWorkbenchWindowAdvisor_WorkingOfflineLog, KEPreferences.isOffline() ? Messages.get().ApplicationWorkbenchWindowAdvisor_true : Messages.get().ApplicationWorkbenchWindowAdvisor_false), null);
        }
        Application.registerConfigurationListener();
        SWToolsPlatform.initializeAllTools();
        KExCmdLine cmdLine = new KExCmdLine(Application.argsList);
        if (cmdLine.cmdSections.isEmpty() || ((CmdSection)cmdLine.cmdSections.get(cmdLine.cmdSections.size() - 1)).getOptionValues("-HeadlessTool") == null) {
            ApplicationWorkbenchWindowAdvisor.setDocumentationResources();
            this.runWithLastOrNewConfig();
        }
        SWTFactoryProxy.INSTANCE.setTestId((Widget)Objects.requireNonNull(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getShell(), "MainShell");
        assert (this.barAdvisor != null);
        this.barAdvisor.mainMenuFixes();
    }

    private static void setDocumentationResources() {
        Bundle bundle;
        String docBundleId;
        IProduct product = Platform.getProduct();
        String string = docBundleId = product != null ? product.getProperty("documentationBundleId") : null;
        if (docBundleId == null || UtilsText.isEmpty((String)docBundleId)) {
            docBundleId = "com.nxp.swtools.doc.mcuxweb";
        }
        if ((bundle = Platform.getBundle((String)docBundleId)) != null) {
            SwToolsProductConfiguration.getRegisteredProducts().forEach(p -> DocFactoryProxy.INSTANCE.setDocumentationResources(p.getProductId(), bundle, "resources/support/help/"));
        }
    }

    protected void runWithLastOrNewConfig() {
        UIJobHelper.runUIJob(() -> {
            if (!SWToolsProperties.isPropertyTrue((String)"com.swtools.test.silentMode")) {
                Application.showAnalyticsInfoDialog();
                if (!Application.loadConfigFromCMD(Application.cmdSection)) {
                    if (!ApplicationWorkbenchWindowAdvisor.autoloadLastConfig()) {
                        ISharedConfiguration configuration = SWToolsPlatform.getSharedConfigurationSingleton();
                        configuration.clearDirty();
                        new NewConfigurationCommandHandler().launchWizard(WizardData.WizardType.STARTUP);
                    }
                } else {
                    Application.setLinkProjectFromCMD(Application.cmdSection, true);
                }
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(() -> {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    ApplicationWorkbenchWindowAdvisor.runTool();
                    SwitchToolCommandHandler.refreshCommand();
                    Application.runCheckForNewVersion();
                }
            });
        }, (String)"Opening new configuration", (boolean)true);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static boolean autoloadLastConfig() {
        if (!KEPreferences.getAutoLoadPreviousMexPreference()) {
            return false;
        }
        @NonNull List recentConfigs = KEPreferences.getRecentConfigFileNames();
        if (recentConfigs.isEmpty()) {
            return false;
        }
        String mexFilename = (String)recentConfigs.get(0);
        if (mexFilename.isEmpty()) {
            return false;
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return false;
        }
        Shell shell = activeWindow.getShell();
        if (shell == null) {
            return false;
        }
        return ConfigurationUtils.openConfiguration((Shell)shell, (String)mexFilename, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.AUTO_REOPEN);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void autoloadLastConfigInJob() {
        IFile mexResource;
        if (!KEPreferences.getAutoLoadPreviousMexPreference()) {
            return;
        }
        @NonNull List recentConfigs = KEPreferences.getRecentConfigFileNames();
        if (recentConfigs.isEmpty()) {
            return;
        }
        final String mexFilename = (String)recentConfigs.get(0);
        if (mexFilename.isEmpty()) {
            return;
        }
        Job job = new Job(com.nxp.swtools.utils.Messages.get().ConfigurationUtils_Task_OpeningConfig){

            public IStatus run(IProgressMonitor monitor) {
                IFile mexResource;
                ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
                if (!config.isEmpty()) {
                    return Status.OK_STATUS;
                }
                if (SWToolsPlatform.isRunningInEclipseIde() && ((mexResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)mexFilename))) == null || !mexResource.isAccessible())) {
                    return Status.OK_STATUS;
                }
                try {
                    AtomicBoolean result = new AtomicBoolean(false);
                    IRunnableWithProgress runnable = ConfigurationUtils.createRunnableToOpenConfiguration((Shell)ShellProvider.getAnyShellParent(), (String)mexFilename, null, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.AUTO_REOPEN, (AtomicBoolean)result);
                    runnable.run(monitor);
                    return Status.OK_STATUS;
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
        if (SWToolsPlatform.isRunningInEclipseIde() && (mexResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)mexFilename))) != null && mexResource.isAccessible()) {
            job.setRule((ISchedulingRule)mexResource);
        }
        job.setUser(Application.isAnyToolPerspectiveActive());
        job.schedule();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void runTool() {
        try {
            IPerspectiveDescriptor perspective;
            IWorkbenchPage page;
            IWorkbenchWindow win;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (win = workbench.getActiveWorkbenchWindow()) != null && (page = win.getActivePage()) != null && (perspective = page.getPerspective()) != null) {
                Application.setSelectedPerspective(perspective.getId());
                return;
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, "NPE", e);
        }
        @Nullable SwToolsProduct tool = null;
        String perspectiveToRun = "com.nxp.swtools.framework.perspective";
        @NonNull Collection registeredProducts = SwToolsProductConfiguration.getRegisteredProducts();
        switch (registeredProducts.size()) {
            case 0: {
                LOGGER.severe("No tool available");
                break;
            }
            case 1: {
                tool = (SwToolsProduct)registeredProducts.iterator().next();
                LOGGER.config("Only one tool is present, it will be run by default.");
                break;
            }
            default: {
                tool = (SwToolsProduct)CollectionsUtils.findAny(registeredProducts.stream(), p -> p.getProductId().equals("Pins"));
                if (tool != null) break;
                LOGGER.warning("There is more than one tool, but Pins tool is not available (and should start by default).");
            }
        }
        if (tool != null) {
            Application.setSelectedTool(tool);
        } else {
            PerspectivesHelper.switchPerspective((String)perspectiveToRun);
        }
    }

    public void postWindowClose() {
        super.postWindowClose();
        Application.stopAnalytics();
        Application.uploadAnalytics();
    }

    private void registerListeners() {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        config.addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
                ApplicationWorkbenchWindowAdvisor.updateAppTitleBar(sharedConfiguration);
            }

            public void commonConfigurationChanged(@NonNull ISharedConfiguration sharedConfiguration) {
                ApplicationWorkbenchWindowAdvisor.updateAppTitleBar(sharedConfiguration);
                ApplicationWorkbenchWindowAdvisor.this.updateSourceProviders();
            }

            public void dirtyChanged(@NonNull ISharedConfiguration sharedConfiguration) {
                ApplicationWorkbenchWindowAdvisor.updateAppTitleBar(sharedConfiguration);
                ApplicationWorkbenchWindowAdvisor.this.updateSourceProviders();
            }

            public void configurationChanged(@NonNull ISharedConfiguration sharedConfiguration, @NonNull IConfigChangeContext changeContext) {
                if ("McuConfiguration".equals(changeContext.getToolId()) && changeContext.getSource() == sharedConfiguration.getCommonConfig()) {
                    ApplicationWorkbenchWindowAdvisor.updateAppTitleBar(sharedConfiguration);
                }
            }

            public int getListenerOrder() {
                return Integer.MAX_VALUE;
            }
        });
        KEPreferences.addListener(() -> ApplicationWorkbenchWindowAdvisor.updateAppTitleBar());
    }

    public void updateSourceProviders() {
        ISourceProviderService service;
        if (this.configProvider == null && !Objects.isNull(service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class))) {
            assert (service != null);
            ISourceProvider provider = service.getSourceProvider("com.nxp.swtools.configuration.isDirty");
            if (provider instanceof ConfigurationSourceProvider) {
                this.configProvider = (ConfigurationSourceProvider)provider;
            }
        }
        if (this.configProvider != null) {
            Runnable r = () -> this.configProvider.updateConfigurationState();
            if (Display.getCurrent() == null) {
                UIJobHelper.runUIJobSystem((Runnable)r);
            } else {
                r.run();
            }
        }
    }

    public static void updateAppTitleBar() {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        ApplicationWorkbenchWindowAdvisor.updateAppTitleBar(config);
    }

    public static void updateAppTitleBar(ISharedConfiguration sharedConfig) {
        if (SWToolsPlatform.isRunningInEclipseIde()) {
            LOGGER.warning("Modifying the title bar of Eclipse IDE not allowed. Only in the RCP application");
            assert (false);
            return;
        }
        ICommonConfig mcu = sharedConfig.getCommonConfig();
        String confName = sharedConfig.getLocationOnDisk();
        if (UtilsText.isEmpty((String)confName)) {
            confName = UtilsText.safeString((String)mcu.getName());
            if (confName.isEmpty()) {
                confName = mcu.getMcu();
            }
            if (!confName.isEmpty()) {
                confName = String.valueOf(confName) + ".mex";
            }
        } else {
            assert (confName != null);
            confName = UtilsText.safeString((String)new File(confName).getName());
        }
        if (confName.length() > 30) {
            confName = String.valueOf(confName.substring(0, 30)) + "...";
        }
        String suffix = KEPreferences.isOffline() ? Messages.get().ApplicationWorkbenchWindowAdvisor_TitleOfflineStatus : "";
        String dirty = sharedConfig.isDirty() ? "*" : "";
        String finalConfName = confName;
        Runnable r = () -> ApplicationWorkbenchWindowAdvisor.lambda$7((IMcuSelection)mcu, sharedConfig, finalConfName, dirty, suffix);
        UIJobHelper.runUIJobSystem((Runnable)r);
    }

    public boolean preWindowShellClose() {
        SharedController.getInstance().dispose();
        return super.preWindowShellClose();
    }

    private static /* synthetic */ void lambda$7(IMcuSelection iMcuSelection, ISharedConfiguration iSharedConfiguration, String string, String string2, String string3) {
        String mcuSelected = UtilsText.safeString((String)iMcuSelection.getMcu());
        if (!mcuSelected.isEmpty()) {
            ProcessorCore selCore = iSharedConfiguration.getCommonConfig().getSelectedCore();
            mcuSelected = selCore != null ? String.valueOf(mcuSelected) + ", " + selCore.getName() : String.valueOf(mcuSelected) + ", " + Messages.get().ApplicationWorkbenchWindowAdvisor_TitleNoCoreSelected;
        }
        if (string.isEmpty() && mcuSelected.isEmpty()) {
            String toolName = Application.getSelectedTool();
            if (!UtilsText.isEmpty((String)toolName)) {
                Utils.setTitle(UtilsText.format((String)"{0}{1} {4}", (Object[])new Object[]{string2, toolName, string, mcuSelected, string3}));
            }
        } else {
            Utils.setTitle(UtilsText.format((String)"{0}{1} - {2} ({3}){4}", (Object[])new Object[]{string2, Application.getSelectedTool(), string, mcuSelected, string3}));
        }
    }
}

