/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.UpdateStatus;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachData;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.SdkAvailabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkDescriptorBuilder;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class SdkAttachDataHolder {
    private static Map<String, Set<SdkAttachData>> sdkAttachData = new ConcurrentHashMap<String, Set<SdkAttachData>>();

    private SdkAttachDataHolder() {
    }

    public static Set<SdkAttachData> getProjectSdkAttachData(String projectName) {
        return sdkAttachData.getOrDefault(projectName, Collections.emptySet());
    }

    public static List<IProject> getProjectsSdkAttachedTo(SdkDescriptor sdkDescriptor) {
        if (sdkDescriptor == null) {
            return Collections.emptyList();
        }
        String sdkId = sdkDescriptor.getId();
        return SdkManagementUtils.getAvailableProjects().stream().filter(project -> SdkAttachDataHelper.getSdksAttachedToProject(project, false).stream().anyMatch(sdk -> sdkId.equals(sdk.getId()))).collect(Collectors.toList());
    }

    public static void cleanupProjectAttachData(IProject project) {
        if (project != null) {
            sdkAttachData.remove(project.getName());
        }
    }

    public static boolean isSdkAttachedToProjectConfiguration(String projectName, String configurationName, String sdkId) {
        if (projectName == null || configurationName == null || sdkId == null || !SdkManagementUtils.isSdkExists(sdkId)) {
            return false;
        }
        Set projectSdkAttachData = sdkAttachData.getOrDefault(projectName, Collections.emptySet());
        if (projectSdkAttachData.isEmpty()) {
            return false;
        }
        for (SdkAttachData sdkAttachDataItem : projectSdkAttachData) {
            if (!sdkId.equals(sdkAttachDataItem.getSdkId())) continue;
            if (sdkAttachDataItem.isSdkMissed()) {
                return false;
            }
            if (sdkAttachDataItem.getConfigurations().isEmpty()) {
                return true;
            }
            return sdkAttachDataItem.getConfigurations().stream().filter(Objects::nonNull).anyMatch(attachDataConfig -> attachDataConfig.equals(configurationName));
        }
        return false;
    }

    public static boolean isSdkAttachedToProject(SdkDescriptor sdk, IProject project) {
        return SdkAttachDataHolder.isSdkAttachedToProject(sdk.getId(), project);
    }

    public static boolean isSdkAttachedToProject(String sdkId, IProject project) {
        if (!Objects.toString(sdkId, "").isEmpty()) {
            if (SdkAttachDataHolder.getProjectAttachData(project).stream().map(SdkAttachData::getSdkId).anyMatch(sdkId::equals)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSdkAttached(SdkDescriptor sdk) {
        return sdkAttachData.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream()).anyMatch(attachDataItem -> attachDataItem.getSdkId().equals(sdk.getId()));
    }

    public static boolean hasProjectAttachedSdks(String projectName) {
        return !SdkAttachDataHolder.getProjectSdkAttachData(projectName).isEmpty();
    }

    public static Collection<SdkAttachData> getProjectAttachData(IProject project) {
        Set<SdkAttachData> projectAttachData = sdkAttachData.getOrDefault(project.getName(), Collections.emptySet());
        if (projectAttachData.isEmpty()) {
            List<SdkAttachData> sdkAttachDataEntries = SdkAttachDataHelper.loadSdkAttachDataFromProjectPreferences(project);
            if (sdkAttachDataEntries.isEmpty()) {
                SdkAttachDataHolder.cleanupProjectAttachData(project);
            } else {
                SdkAttachDataHolder.addAttachData(sdkAttachDataEntries, project.getName());
            }
            return sdkAttachDataEntries;
        }
        return projectAttachData;
    }

    public static void attachSdkToProjectConfiguration(String sdkId, String configurationName, IProject project) {
        Collection<SdkAttachData> projectAttachData = SdkAttachDataHolder.getProjectAttachData(project);
        SdkAttachData attachData = SdkAttachDataHolder.getSdkAttachData(sdkId, projectAttachData);
        if (attachData != null) {
            List<String> configurations = attachData.getConfigurations();
            if (attachData.isSdkMissed()) {
                configurations.clear();
                attachData.setIsSdkMissed(false);
            }
            if (configurations.contains(configurationName)) {
                SdkCoreActivator.getInstance().logInfo(NLS.bind((String)"SDK {0} already attached to configuration {1} of the project {2}.", (Object[])new String[]{sdkId, configurationName, project.getName()}));
                return;
            }
            configurations.add(configurationName);
            attachData.setConfigurations(configurations);
        } else {
            attachData = new SdkAttachData(sdkId);
            attachData.addConfiguration(configurationName);
            projectAttachData.add(attachData);
        }
        SdkAttachDataHolder.updateSdkAttachDataProjectPreferences(project, projectAttachData, true);
    }

    public static IStatus detachSdkFromProjectConfiguration(String sdkId, String configName, IProject project) {
        Collection<SdkAttachData> projectAttachData = SdkAttachDataHolder.getProjectAttachData(project);
        SdkAttachData attachData = SdkAttachDataHolder.getSdkAttachData(sdkId, projectAttachData);
        if (attachData != null) {
            List<String> configurations = attachData.getConfigurations();
            if (!configurations.removeIf(configName::equals)) {
                String message = NLS.bind((String)"SDK {0} is not attached to Configuration {1} of the Project {2}. Nothing done.", (Object[])new String[]{sdkId, configName, project.getName()});
                IStatus status = SdkCoreActivator.getInstance().createError(message);
                SdkCoreActivator.getInstance().logInfo(message);
                return status;
            }
            if (configurations.isEmpty()) {
                projectAttachData.remove(attachData);
            } else {
                attachData.setConfigurations(configurations);
            }
        } else {
            String message = NLS.bind((String)"SDK {0} is not attached to the Project {1}. Nothing done.", (Object[])new String[]{sdkId, project.getName()});
            IStatus status = SdkCoreActivator.getInstance().createError(message);
            SdkCoreActivator.getInstance().logInfo(message);
            return status;
        }
        SdkAttachDataHolder.updateSdkAttachDataProjectPreferences(project, projectAttachData, false);
        return Status.OK_STATUS;
    }

    public static List<IConfiguration> getProjectConfigurationsSdkAttachedTo(IProject project, String sdkId) {
        if (project == null || sdkId == null || sdkId.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IConfiguration> attachedConfigurations = new ArrayList<IConfiguration>();
        Collection<SdkAttachData> projectAttachData = SdkAttachDataHolder.getProjectAttachData(project);
        SdkAttachData attachDataHolder = projectAttachData.stream().filter(data -> sdkId.equals(data.getSdkId())).findFirst().orElse(null);
        if (attachDataHolder != null) {
            List projectConfigurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
            List<String> attachDataConfigurations = attachDataHolder.getConfigurations();
            if (attachDataConfigurations.isEmpty()) {
                attachedConfigurations.addAll(projectConfigurations);
            } else {
                attachDataConfigurations.stream().filter(Objects::nonNull).forEach(attachDataConfiguration -> projectConfigurations.stream().filter(projectConfiguration -> attachDataConfiguration.equals(projectConfiguration.getName())).forEach(attachedConfigurations::add));
            }
        }
        return attachedConfigurations;
    }

    public static void updateProjectAttachData(SdkDescriptor sdk, IProject project, MultiStatus result) {
        SdkAttachData sdkAttachDataItem = SdkAttachDataHolder.getProjectSdkAttachData(sdk.getId(), project);
        if (sdkAttachDataItem != null) {
            sdkAttachDataItem.setSdkTargetFolder(SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdk, (IProject)project));
            Map<String, List<UpdateStatus>> attachDataByConfigs = sdkAttachDataItem.getAttachData();
            Arrays.stream(result.getChildren()).filter(status -> status.isOK() && status instanceof UpdateStatus).map(status -> (UpdateStatus)status).forEach(status -> {
                boolean bl = attachDataByConfigs.computeIfAbsent(status.getConfigurationName(), s -> new ArrayList()).add(status);
            });
            sdkAttachDataItem.setAttachData(attachDataByConfigs);
        }
        SdkAttachDataHolder.updateProjectSdkAttachPreferences(project);
    }

    public static void updateProjectSdkAttachData(SdkDescriptor sdk, IProject project, IConfiguration configuration) {
        SdkAttachData sdkAttachData = SdkAttachDataHolder.getProjectSdkAttachData(sdk.getId(), project);
        if (sdkAttachData != null) {
            Map<String, List<UpdateStatus>> attachDataByConfigs = sdkAttachData.getAttachData();
            attachDataByConfigs.remove(configuration.getName());
            sdkAttachData.setAttachData(attachDataByConfigs);
        }
        SdkAttachDataHolder.updateProjectSdkAttachPreferences(project);
    }

    public static void removeSdkAttachPreferences(IProject project, String sdkId) {
        try {
            IEclipsePreferences prefs = new ProjectScope(project).getNode("com.nxp.s32ds.cle.ide.sdk.attached.sdks.data");
            prefs.remove(sdkId);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to remove persistent SDK attach data for project {0}", (Object)project.getName()), bse);
        }
    }

    public static List<SdkDescriptor> verboseProjectAttachData(IProject project, Map<String, String> unavailableSdks, Map<String, String> missedSdks) {
        ArrayList<SdkDescriptor> result = new ArrayList<SdkDescriptor>();
        Collection<SdkAttachData> attachDatas = SdkAttachDataHolder.getProjectAttachData(project);
        for (SdkAttachData ad : attachDatas) {
            String sdkId = ad.getSdkId();
            IStatus status = SdkAvailabilityChecker.checkAvailability(sdkId);
            int statusCode = status.getCode();
            if (statusCode == SdkAttachStatuses.ERROR_SDK_MISSED.getCode()) {
                ad.setIsSdkMissed(true);
                missedSdks.put(sdkId, NLS.bind((String)"SDK {0} is not found in workspace", (Object)sdkId));
                continue;
            }
            SdkDescriptor sdk = SdkDescriptors.getSdkDescriptor((String)sdkId);
            if (statusCode == SdkAttachStatuses.ERROR_SDK_LOCATION.getCode()) {
                IPath sdkPath = EnvironmentSdkCore.getResolvedSdkPath((String)sdkId);
                unavailableSdks.put(sdkId, NLS.bind((String)"SDK {0} is not found: invalid path: {1}", (Object)sdkId, (Object)(sdkPath != null ? sdkPath : "")));
            }
            if (ad.isSdkMissed()) {
                ad.setIsSdkMissed(false);
            }
            result.add(sdk);
        }
        SdkAttachDataHolder.addAttachData(attachDatas, project.getName());
        return result;
    }

    public static List<SdkDescriptor> getUndefinedSdksByProject(IProject project) {
        List<SdkDescriptor> sdks = SdkManagementUtils.getFilteredSdks((SdkFilter)new ProjectCompatibleSdksFilter(project));
        return SdkAttachDataHolder.getProjectAttachData(project).stream().map(data -> SdkAttachDataHolder.getSdkByAttachDataSdkId(data.getSdkId())).filter(Objects::nonNull).filter(sdkProject -> sdks.stream().noneMatch(sdkPlatform -> sdkPlatform.getId().equals(sdkProject.getId()))).collect(Collectors.toList());
    }

    private static SdkDescriptor getSdkByAttachDataSdkId(String sdkId) {
        if (sdkId == null || sdkId.isEmpty()) {
            return null;
        }
        SdkDescriptor sdkDescriptor = SdkDescriptors.getSdkDescriptor((String)sdkId);
        if (sdkDescriptor != null) {
            return sdkDescriptor;
        }
        String[] nameVersion = SdkAttachDataHolder.parseSdkNameVersion(sdkId);
        if (nameVersion != null) {
            return new SdkDescriptorBuilder().createHeader(nameVersion[0], nameVersion[1], "", SdkType.UNKNOWN, null, null).build();
        }
        return null;
    }

    private static String[] parseSdkNameVersion(String sdkId) {
        String splitter = "_";
        String[] sdkNameVersion = new String[2];
        String[] split = sdkId.split(splitter);
        if (split.length <= 2) {
            SdkCoreActivator.getInstance().logError(String.format("Invalid format encountered while parsing sdk id: %s", sdkId));
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        IntStream.range(0, split.length - 2).forEach(p -> {
            nameBuilder.append(split[p]);
            if (p < split.length - 3) {
                nameBuilder.append(splitter);
            }
        });
        sdkNameVersion[0] = nameBuilder.toString();
        sdkNameVersion[1] = split[split.length - 2];
        return sdkNameVersion;
    }

    private static void updateProjectSdkAttachPreferences(IProject project) {
        try {
            IEclipsePreferences prefs = new ProjectScope(project).getNode("com.nxp.s32ds.cle.ide.sdk.attached.sdks.data");
            Collection<SdkAttachData> projectAttachData = SdkAttachDataHolder.getProjectAttachData(project);
            projectAttachData.forEach(attachData -> prefs.put(attachData.getSdkId(), attachData.convertToXml()));
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to persist SDK attach data for project {0}", (Object)project.getName()), bse);
        }
    }

    private static SdkAttachData getProjectSdkAttachData(String sdkId, IProject project) {
        return SdkAttachDataHolder.getSdkAttachData(sdkId, SdkAttachDataHolder.getProjectAttachData(project));
    }

    private static void updateSdkAttachDataProjectPreferences(IProject project, Collection<SdkAttachData> sdkAttachDataSet, boolean isAttach) {
        String sdkAttachDataString = String.join((CharSequence)":", sdkAttachDataSet.stream().map(SdkAttachData::toRecord).collect(Collectors.toList()));
        try {
            String sdkManagementVersion;
            IEclipsePreferences prefs = new ProjectScope(project).getNode("com.nxp.s32ds.cle.runtime.sdk");
            if (isAttach && sdkAttachDataSet.size() == 1 && !Objects.toString(sdkManagementVersion = SdkRegistryCore.getSdkManagementVersion(), "").isEmpty() && prefs.get("com.freescale.s32ds.cross.sdk.support.attachedSDKs", "").isEmpty()) {
                prefs.put("com.nxp.s32ds.cle.runtime.sdk.mgmt.version", sdkManagementVersion);
            }
            prefs.put("com.freescale.s32ds.cross.sdk.support.attachedSDKs", sdkAttachDataString);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to persist SDK attach data for project {0}", (Object)project.getName()), bse);
        }
        SdkAttachDataHolder.addAttachData(sdkAttachDataSet, project.getName());
    }

    private static SdkAttachData getSdkAttachData(String sdkId, Collection<SdkAttachData> projectAttachData) {
        return projectAttachData.stream().filter(pad -> sdkId.equals(pad.getSdkId())).findFirst().orElse(null);
    }

    private static void addAttachData(Collection<SdkAttachData> sdkAttachDataItem, String projectName) {
        sdkAttachData.computeIfAbsent(projectName, s -> new LinkedHashSet()).addAll(sdkAttachDataItem);
    }
}

