/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentListenerManager;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventBuilder;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangePayload;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.ext.rcp.datacollection.core.DataCollections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkAttachHelper {
    private SdkAttachHelper() {
    }

    public static void restoreSdksProjectFolders(Map<String, Set<ResourceSdkDescriptor>> missingResources, IProject project) {
        ArrayList<SdkDescriptor> sdksToRestore = new ArrayList<SdkDescriptor>();
        for (Map.Entry<String, Set<ResourceSdkDescriptor>> entry : missingResources.entrySet()) {
            SdkDescriptor sdkDescriptor = SdkDescriptors.getSdkDescriptor((String)entry.getKey());
            Set<ResourceSdkDescriptor> resources = entry.getValue();
            if (sdkDescriptor == null || resources == null || resources.isEmpty() || !SdkAttachHelper.restoreSdkProjectFolders(sdkDescriptor, new ArrayList<ResourceSdkDescriptor>(resources), project).isOK()) continue;
            sdksToRestore.add(sdkDescriptor);
        }
    }

    public static IStatus restoreSdkProjectFolders(SdkDescriptor sdkDescriptor, List<ResourceSdkDescriptor> missedPaths, IProject project) {
        String sdkId = sdkDescriptor.getId();
        try {
            List<IConfiguration> attachedConfigs = SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo(project, sdkId);
            IFolder sdkFolder = SdkProjectResourcesUtils.getSdkTargetFolder((SdkDescriptor)sdkDescriptor, (IProject)project);
            SdkAttachHelper.restoreSdkFolder(sdkFolder, attachedConfigs);
            EnvironmentSdkDescriptor environmentSdkDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkId);
            if (environmentSdkDescriptor == null) {
                IStatus errorStatus = SdkCoreActivator.getInstance().createError(NLS.bind((String)"Unable to restore project folders for SDK {0}: ENV does not exist.", (Object)sdkId));
                SdkCoreActivator.getInstance().log(errorStatus);
                return errorStatus;
            }
            Map<EnvironmentSdkDescriptor, Set<ResourceSdkDescriptor>> pathsToRestore = SdkModulesHelper.getResourcesGrouppedByEnvironment(sdkId, missedPaths);
            Set<Object> sdkPaths = pathsToRestore.getOrDefault(environmentSdkDescriptor, Collections.emptySet());
            SdkAttachHelper.restoreSdkFolders(sdkDescriptor, project, attachedConfigs, null, sdkPaths);
            List<SdkDescriptor> refSdks = SdkModulesHelper.getRefModulesSdksDescriptors(sdkId);
            for (SdkDescriptor refSdk : refSdks) {
                EnvironmentSdkDescriptor refSdkEnvironment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)refSdk.getId());
                if (refSdkEnvironment == null) continue;
                sdkPaths = pathsToRestore.getOrDefault(refSdkEnvironment, Collections.emptySet());
                SdkAttachHelper.restoreSdkFolders(refSdk, project, attachedConfigs, sdkFolder, sdkPaths);
            }
        }
        catch (CoreException ce) {
            IStatus errorStatus = SdkCoreActivator.getInstance().createError(NLS.bind((String)"Unable to restore project folders for SDK {0}: {1}", (Object)sdkId, (Object)ce.getMessage()));
            SdkCoreActivator.getInstance().log(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    public static void notifySDKAttached(SdkDescriptor sdkDescriptor, IProject project) {
        HashMap<String, Object> payLoadContent = new HashMap<String, Object>();
        payLoadContent.put("s32ds.project", project);
        payLoadContent.put("s32ds.project.sdk", sdkDescriptor);
        ComponentChangeEventBuilder builder = ComponentChangeEventBuilder.builder();
        builder.archetypeId("com.nxp.s32ds.cle.ide.component.project");
        builder.componentId("s32ds.project");
        builder.actionId("s32ds.project.action.sdk.attach");
        ComponentChangePayload payLoadComponent = new ComponentChangePayload(payLoadContent);
        builder.payload((Object)payLoadComponent);
        ComponentChangeEvent sdkAttachedEvent = builder.build();
        if (sdkAttachedEvent != null) {
            ComponentListenerManager.INSTANCE.notifyComponentChange(sdkAttachedEvent);
        }
    }

    public static void notifySDKDetached(SdkDescriptor sdkDescriptor, IProject project) {
        HashMap<String, Object> payLoadContent = new HashMap<String, Object>();
        payLoadContent.put("s32ds.project", project);
        payLoadContent.put("s32ds.project.sdk", sdkDescriptor);
        ComponentChangeEventBuilder builder = ComponentChangeEventBuilder.builder();
        builder.archetypeId("com.nxp.s32ds.cle.ide.component.project");
        builder.componentId("s32ds.project");
        builder.actionId("s32ds.project.action.sdk.detach");
        ComponentChangePayload payLoadComponent = new ComponentChangePayload(payLoadContent);
        builder.payload((Object)payLoadComponent);
        ComponentChangeEvent sdkDetachedEvent = builder.build();
        if (sdkDetachedEvent != null) {
            ComponentListenerManager.INSTANCE.notifyComponentChange(sdkDetachedEvent);
        }
    }

    public static void collectAttachedSdkData(SdkDescriptor sdkDescriptor, IProject project) {
        ProjectContextSettings settings = new ProjectContextSettings(project);
        DataCollections.sendEventCollectSdk((String)sdkDescriptor.getId(), (String)sdkDescriptor.getName(), (String)sdkDescriptor.getVersion(), (String)settings.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.device.id"), (String)settings.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.core.id"));
    }

    public static boolean isSdkOldNamingConvention(IProject project, SdkDescriptor sdkDescriptor) {
        String containerFolder;
        String targetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project);
        return !targetFolderName.equals(containerFolder = Path.fromOSString((String)targetFolderName).uptoSegment(1).toString()) && project.getFolder(containerFolder).isAccessible() && project.getFolder(containerFolder).findMember(Path.fromOSString((String)targetFolderName).lastSegment()) == null;
    }

    private static void restoreSdkFolders(SdkDescriptor sdkDescriptor, IProject project, List<IConfiguration> attachedConfigs, IFolder holderSdkFolder, Set<ResourceSdkDescriptor> pathsToRestore) throws CoreException {
        if (pathsToRestore.isEmpty()) {
            return;
        }
        IPath sdkBasePath = EnvironmentSdkCore.getResolvedSdkPath((String)sdkDescriptor.getId());
        String targetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project);
        IFolder sdkFolder = holderSdkFolder == null ? project.getFolder(targetFolderName) : holderSdkFolder.getFolder(targetFolderName);
        for (ResourceSdkDescriptor resource : pathsToRestore) {
            IPath path = Path.fromOSString((String)resource.getPath());
            String copyPath = resource.getCopyToProjectPath();
            if (copyPath != null && !copyPath.isEmpty() && !copyPath.equals(".")) {
                SdkAttachHelper.restoreSdkFolder(project.getFolder(copyPath), attachedConfigs);
                continue;
            }
            IPath srcRelPath = path.makeRelativeTo(sdkBasePath);
            IFolder folder = sdkFolder;
            int i = 0;
            while (i < srcRelPath.segmentCount() - 1) {
                folder = folder.getFolder(srcRelPath.segment(i));
                SdkAttachHelper.restoreSdkFolder(folder, attachedConfigs);
                ++i;
            }
        }
    }

    private static boolean restoreSdkFolder(IFolder sdkFolder, List<IConfiguration> configurations) throws CoreException {
        if (sdkFolder.exists()) {
            return false;
        }
        IFolder matchedFolder = SdkAttachHelper.getMatchedFolder(sdkFolder);
        if (matchedFolder != null) {
            String matchedFolderName = matchedFolder.getFullPath().lastSegment();
            for (IConfiguration configuration : configurations) {
                ArrayList<ICSourceEntry> updatedSources = new ArrayList<ICSourceEntry>();
                ICSourceEntry[] iCSourceEntryArray = configuration.getSourceEntries();
                int n = iCSourceEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICSourceEntry sourceEntry = iCSourceEntryArray[n2];
                    if (!sourceEntry.getFullPath().toString().equals(matchedFolderName)) {
                        updatedSources.add(sourceEntry);
                    }
                    ++n2;
                }
                configuration.setSourceEntries(updatedSources.toArray(new ICSourceEntry[updatedSources.size()]));
            }
            matchedFolder.move(sdkFolder.getFullPath(), 1, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        return false;
    }

    private static IFolder getMatchedFolder(IFolder sdkFolder) throws CoreException {
        final IFolder[] matchedFolder = new IFolder[1];
        final String sdkFolderPath = sdkFolder.getFullPath().toOSString();
        sdkFolder.getProject().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                IFolder folder;
                String folderFullPath;
                if (resource instanceof IFolder && matchedFolder[0] == null && (folderFullPath = (folder = (IFolder)resource).getFullPath().toOSString()).equalsIgnoreCase(sdkFolderPath) && !folderFullPath.equals(sdkFolderPath)) {
                    matchedFolder[0] = folder;
                    return false;
                }
                return true;
            }
        });
        return matchedFolder[0];
    }
}

