/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach.checkers;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkProjectConfigurationUpdater;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.checkers.SdkAttachMissingProjectFilesCheckHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.files.AbstractSdkProjectFilesChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.files.SdkProjectFilesCheckStatus;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachResourcesProcessor;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachSourcePathsProcessor;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class SdkAttachMissingProjectFilesChecker {
    private IProject project;
    private SdkAttachMissingProjectFilesCheckHandler missingFilesHandler;

    public SdkAttachMissingProjectFilesChecker(IProject project, SdkAttachMissingProjectFilesCheckHandler missingFilesHandler) {
        this.project = project;
        this.missingFilesHandler = missingFilesHandler;
    }

    public void checkSdksAttachedToProject() {
        List<SdkDescriptor> sdksAttachedToProject = SdkAttachDataHelper.getSdksAttachedToProject(this.project, false);
        if (sdksAttachedToProject.isEmpty()) {
            return;
        }
        this.checkMissedProjectFiles(sdksAttachedToProject);
    }

    private void checkMissedProjectFiles(List<SdkDescriptor> sdksAttachedToProject) {
        try {
            this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            Map<String, Set<ResourceSdkDescriptor>> missingProjectFiles = this.checkMissedSdkTargetFiles(sdksAttachedToProject);
            if (!missingProjectFiles.isEmpty() && this.missingFilesHandler != null && this.missingFilesHandler.isRestoreMissingProjectFiles(missingProjectFiles, this.project)) {
                SdkAttachMissingProjectFilesChecker.restoreMissingProjectFiles(missingProjectFiles, this.project);
            }
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to refresh project {0} structure.", (Object)this.project.getName()), ce);
        }
    }

    private Map<String, Set<ResourceSdkDescriptor>> checkMissedSdkTargetFiles(List<SdkDescriptor> sdksAttachedToProject) {
        ArrayList<SdkDescriptor> preparedAttachedSdks = new ArrayList<SdkDescriptor>();
        List aggregatedSdks = sdksAttachedToProject.stream().filter(sdk -> !ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdk.getId()).isEmpty()).collect(Collectors.toList());
        sdksAttachedToProject.removeAll(aggregatedSdks);
        for (SdkDescriptor aggregatedSdk : aggregatedSdks) {
            preparedAttachedSdks.add(aggregatedSdk);
            SdkModulesHelper.getRefModulesSdksDescriptors(aggregatedSdk.getId()).forEach(sdksAttachedToProject::remove);
        }
        preparedAttachedSdks.addAll(sdksAttachedToProject);
        HashMap<String, Set<ResourceSdkDescriptor>> checkResults = new HashMap<String, Set<ResourceSdkDescriptor>>();
        for (SdkDescriptor sdk2 : preparedAttachedSdks) {
            IStatus checkFilesStatus = AbstractSdkProjectFilesChecker.getMissingProjectFilesChecker(sdk2, this.project).checkFiles();
            if (checkFilesStatus.isOK()) continue;
            Map<String, Set<ResourceSdkDescriptor>> resultFiles = ((SdkProjectFilesCheckStatus)checkFilesStatus).getResultFiles();
            for (Map.Entry<String, Set<ResourceSdkDescriptor>> e : resultFiles.entrySet()) {
                String sdkId = e.getKey();
                Set<ResourceSdkDescriptor> missedPaths = e.getValue();
                if (aggregatedSdks.isEmpty()) {
                    checkResults.computeIfAbsent(sdkId, s -> new HashSet()).addAll(missedPaths);
                    continue;
                }
                for (SdkDescriptor asdk : aggregatedSdks) {
                    String asdkId = asdk.getId();
                    if (SdkModulesHelper.getRefModulesSdksDescriptors(asdk.getId()).stream().map(EntityDescriptor::getId).anyMatch(id -> id.equals(sdkId))) {
                        checkResults.computeIfAbsent(asdkId, s -> new HashSet()).addAll(missedPaths);
                        continue;
                    }
                    checkResults.computeIfAbsent(sdkId, s -> new HashSet()).addAll(missedPaths);
                }
            }
        }
        return checkResults;
    }

    private static void restoreMissingProjectFiles(Map<String, Set<ResourceSdkDescriptor>> missingResources, IProject project) {
        SdkAttachHelper.restoreSdksProjectFolders(missingResources, project);
        missingResources.keySet().stream().filter(Objects::nonNull).map(SdkDescriptors::getSdkDescriptor).filter(Objects::nonNull).forEach(sdkDescriptor -> SdkAttachMissingProjectFilesChecker.restoreSdk(sdkDescriptor, project));
        SdkProjectResourcesUtils.refreshProjectResources((IProject)project);
    }

    private static void restoreSdk(SdkDescriptor sdkDescriptor, IProject project) {
        List<IConfiguration> configurations = SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo(project, sdkDescriptor.getId());
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        configurations.forEach(configuration -> {
            result.addAll(SdkProjectConfigurationUpdater.updateOptions(configuration, sdkDescriptor, false));
            result.addAll(new SdkAttachResourcesProcessor(sdkDescriptor, (IConfiguration)configuration, null).process());
            SdkAttachSourcePathsProcessor.updateProjectSourceEntries(project, sdkDescriptor, configuration, result);
        });
    }
}

