/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.filtering;

import com.nxp.s32ds.cle.cdt.sdk.core.checkers.SdkAvailabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.SdkProjectCompatibilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkSmartFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.filtering.SdkFilteringUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.lang.LangSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractSdkSmartFilter
implements SdkSmartFilter {
    public abstract FilterOptions options();

    public boolean acceptOptions(SdkDescriptor sdk) {
        String sdkId;
        FilterOptions filterOptions = this.options();
        if (this.skipOptionsCheck(filterOptions, sdkId = sdk.getId())) {
            return true;
        }
        if (!this.checkAvailability(filterOptions, sdkId)) {
            return false;
        }
        if (!this.acceptPlatform(filterOptions, sdkId)) {
            return false;
        }
        if (!this.acceptLanguages(filterOptions, sdkId)) {
            return false;
        }
        if (!this.acceptToolchains(filterOptions, sdkId)) {
            return false;
        }
        if (!this.acceptProcessorAndCores(filterOptions, sdkId)) {
            return false;
        }
        return this.acceptModules(sdkId);
    }

    protected boolean checkAvailability(FilterOptions filterOptions, String sdkId) {
        return filterOptions.isCheckAvailability() && SdkAvailabilityChecker.checkAvailability(sdkId).isOK();
    }

    protected boolean skipOptionsCheck(FilterOptions filterOptions, String sdkId) {
        return AbstractSdkSmartFilter.isSdkFilteringParamsEmpty(sdkId) && !AbstractSdkSmartFilter.isAggregatedSdk(sdkId) || filterOptions == null;
    }

    protected boolean acceptPlatform(FilterOptions projectFilterOptions, String sdkId) {
        boolean isAccepted = true;
        Map platformSdkDescriptorsIds = PlatformSdkDescriptors.getPlatformSdkDescriptorsIds((String)sdkId);
        String sdkPlatformTarget = (String)platformSdkDescriptorsIds.get("com.nxp.s32ds.cle.runtime.sdk.registry.platform.target");
        boolean bl = isAccepted = sdkPlatformTarget.isEmpty() || projectFilterOptions.getPlatform().equalsIgnoreCase(sdkPlatformTarget);
        if (isAccepted) {
            String sdkPlatformHost = (String)platformSdkDescriptorsIds.get("com.nxp.s32ds.cle.runtime.sdk.registry.platform.host");
            isAccepted = sdkPlatformHost.isEmpty() || projectFilterOptions.getHost().startsWith(sdkPlatformHost);
        }
        return isAccepted;
    }

    protected boolean acceptLanguages(FilterOptions filterOptions, String sdkId) {
        LangSdkKind sdkLang;
        LangSdkDescriptor langSdkDescriptor = LangSdkDescriptors.getLangSdkDescriptorBySdkId((String)sdkId);
        LangSdkKind langSdkKind = sdkLang = langSdkDescriptor != null ? langSdkDescriptor.getKind() : LangSdkKind.UNKNOWN;
        return LangSdkKind.ALL == sdkLang || LangSdkKind.UNKNOWN == sdkLang || LangSdkKind.getByValue((String)filterOptions.getLang().getLang()) == sdkLang;
    }

    protected boolean acceptToolchains(FilterOptions filterOptions, String sdkId) {
        List projectToolChains = filterOptions.getToolChains();
        if (projectToolChains.isEmpty()) {
            return true;
        }
        List sdkToolChainsIds = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId).stream().map(ToolChainSdkDescriptor::getToolChainId).filter(toolChainId -> !toolChainId.isEmpty()).collect(Collectors.toList());
        if (sdkToolChainsIds.isEmpty()) {
            return true;
        }
        return projectToolChains.stream().anyMatch(tc -> SdkProjectCompatibilityChecker.checkToolChainsCompatibility(sdkToolChainsIds, tc).isOK());
    }

    protected boolean acceptProcessorAndCores(FilterOptions filterOptions, String sdkId) {
        Map projectHardwareSettings = filterOptions.getHardwareParams();
        Set deviceIdList = (Set)projectHardwareSettings.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        Set deviceCoreIdList = (Set)projectHardwareSettings.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        Set coreIdList = (Set)projectHardwareSettings.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        Set deviceRevisionIdList = (Set)projectHardwareSettings.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
        return SdkFilteringUtils.isSdkAcceptsProjectComponentHardwareIds(sdkId, deviceIdList, deviceCoreIdList, coreIdList, deviceRevisionIdList);
    }

    protected boolean acceptModules(String sdkId) {
        List refModulesSdkDescriptors = ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId);
        if (!refModulesSdkDescriptors.isEmpty()) {
            List refModulesSdks = refModulesSdkDescriptors.stream().map(refModuleSdkDescriptor -> SdkDescriptors.getSdkDescriptor((String)refModuleSdkDescriptor.getModuleSdkId())).filter(Objects::nonNull).collect(Collectors.toList());
            if (refModulesSdks.isEmpty()) {
                return false;
            }
            return refModulesSdks.stream().anyMatch(this::acceptOptions);
        }
        return true;
    }

    private static boolean isSdkFilteringParamsEmpty(String sdkId) {
        Map hardwareSdkDescriptorsIds = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)sdkId);
        LangSdkDescriptor langSdkDescriptor = LangSdkDescriptors.getLangSdkDescriptorBySdkId((String)sdkId);
        Map platformSdkDescriptorsIds = PlatformSdkDescriptors.getPlatformSdkDescriptorsIds((String)sdkId);
        return hardwareSdkDescriptorsIds.values().stream().flatMap(Collection::stream).count() == 0L && (langSdkDescriptor == null || LangSdkKind.UNKNOWN == langSdkDescriptor.getKind()) && platformSdkDescriptorsIds.values().stream().map(String::trim).filter(v -> !v.isEmpty()).count() == 0L && ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId).isEmpty();
    }

    private static boolean isAggregatedSdk(String sdkId) {
        return !ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId).isEmpty();
    }
}

