/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.filtering;

import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkReferenceDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.CoreSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.DeviceCoreSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.DeviceSdkDescriptors;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class SdkHardwareFilter
implements SdkFilter {
    private String deviceCriteriaId;
    private String deviceCoreCriteriaId;
    private String coreCriteriaId;

    public SdkHardwareFilter(String deviceCriteriaId, String deviceCoreCriteriaId, String coreCriteriaId) {
        this.deviceCriteriaId = deviceCriteriaId;
        this.deviceCoreCriteriaId = deviceCoreCriteriaId;
        this.coreCriteriaId = coreCriteriaId;
    }

    public boolean accept(SdkDescriptor sdk) {
        String sdkId = sdk.getId();
        boolean isAcceptedByDevice = this.deviceCriteriaId == null || SdkHardwareFilter.internalAccept(sdkId, DeviceSdkDescriptors.getDeviceSdkDescriptorsByDeviceId((String)this.deviceCriteriaId));
        boolean isAcceptedByDeviceCore = this.deviceCoreCriteriaId == null || SdkHardwareFilter.internalAccept(sdkId, DeviceCoreSdkDescriptors.getDeviceCoreSdkDescriptorsByDeviceCoreId((String)this.deviceCoreCriteriaId));
        boolean isAcceptedByCore = SdkHardwareFilter.internalAcceptByCoreId(sdkId, this.coreCriteriaId);
        return isAcceptedByDevice && isAcceptedByDeviceCore && isAcceptedByCore;
    }

    private static <T extends SdkReferenceDescriptor> boolean internalAccept(String sdkId, Collection<T> hardwareSdkDescriptors) {
        return hardwareSdkDescriptors != null && hardwareSdkDescriptors.stream().anyMatch(d -> sdkId.equals(d.getSdkId()));
    }

    private static boolean internalAcceptByCoreId(String sdkId, String coreCriteriaId) {
        if (coreCriteriaId == null || SdkHardwareFilter.internalAccept(sdkId, CoreSdkDescriptors.getCoreSdkDescriptorsByCoreId((String)coreCriteriaId))) {
            return true;
        }
        Set deviceCoreIds = DeviceDescriptors.getDeviceCoreDescriptors().stream().filter(dcd -> coreCriteriaId.equals(dcd.getCoreId())).map(EntityDescriptor::getId).collect(Collectors.toSet());
        return DeviceCoreSdkDescriptors.getDeviceCoreSdkDescriptors().stream().filter(dcd -> deviceCoreIds.contains(dcd.getDeviceCoreId())).anyMatch(dcd -> sdkId.equals(dcd.getSdkId()));
    }
}

