/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.resource;

import com.nxp.s32ds.cle.cdt.sdk.condition.Condition;
import com.nxp.s32ds.cle.cdt.sdk.core.condition.ConditionsHolder;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.util.Objects;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;

public class ResourceApplicabilityChecker {
    private ResourceApplicabilityChecker() {
    }

    public static boolean isApplicable(ResourceSdkDescriptor resource, IConfiguration configuration) {
        if (ResourceApplicabilityChecker.isApplicableForConfigurations(resource, configuration)) {
            return ResourceApplicabilityChecker.isApplicableForCondition(resource, configuration);
        }
        return false;
    }

    private static boolean isApplicableForConfigurations(ResourceSdkDescriptor resource, IConfiguration configuration) {
        Set relatedConfigurations = resource.getConfigurations();
        return relatedConfigurations == null || relatedConfigurations.isEmpty() || configuration == null || relatedConfigurations.contains(configuration.getBaseId()) || relatedConfigurations.contains(configuration.getName());
    }

    private static boolean isApplicableForCondition(ResourceSdkDescriptor resource, IConfiguration configuration) {
        String toolChainId;
        String conditionRef = resource.getConditionRef();
        if (Objects.toString(conditionRef, "").isEmpty()) {
            return true;
        }
        String sdkId = resource.getSdkId();
        Condition condition = ConditionsHolder.INSTANCE.getCondition(sdkId, toolChainId = resource.getToolChainId(), conditionRef);
        return condition == null || condition.check((Object)configuration);
    }
}

