/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.utils;

import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkBasePathValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.buildstep.BuildStepSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.symbol.SymbolSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.VariablesPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SdkDescriptorUtils {
    private SdkDescriptorUtils() {
    }

    public static Element convertSdkDescriptorToXml(SdkDescriptor sdkDescriptor) throws ParserConfigurationException, CoreException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element rootElement = document.createElement("sdks");
        document.appendChild(rootElement);
        Element sdkElement = sdkDescriptor.convertToXml(document, rootElement);
        String sdkId = sdkDescriptor.getId();
        EnvironmentSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
        PlatformSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
        SdkDescriptorUtils.convertResourcesToXml(sdkDescriptor, document, sdkElement);
        ModuleSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
        BuildStepSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
        return sdkElement;
    }

    private static void convertResourcesToXml(SdkDescriptor sdkDescriptor, Document document, Element sdkElement) throws CoreException {
        String sdkBasePath = sdkDescriptor.getBasePath();
        IStatus validationStatus = new SdkBasePathValidator().validate(sdkBasePath);
        if (!validationStatus.isOK()) {
            SdkCoreActivator.getInstance().logWarning(validationStatus.getMessage());
            return;
        }
        String sdkId = sdkDescriptor.getId();
        List toolChains = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId);
        boolean isHandleOnlyRootToolChainResources = toolChains.stream().allMatch(ToolChainSdkDescriptor::isRootToolChain);
        if (isHandleOnlyRootToolChainResources) {
            List resources;
            String rootToolChainId = String.join((CharSequence)",", toolChains.stream().filter(ToolChainSdkDescriptor::isRootToolChain).map(ToolChainSdkDescriptor::getToolChainId).collect(Collectors.toList()));
            sdkElement.setAttribute("toolchains", rootToolChainId);
            List symbols = SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId((String)sdkId);
            if (!symbols.isEmpty()) {
                Element symbolsElement = document.createElement("symbols");
                sdkElement.appendChild(symbolsElement);
                symbols.forEach(symbol -> {
                    Element element2 = symbol.convertToXml(document, symbolsElement);
                });
            }
            if (!(resources = ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdkId)).isEmpty()) {
                resources.forEach(resource -> {
                    Element element2 = resource.convertToXml(document, sdkElement);
                });
                SdkDescriptorUtils.relativizeResourcesPath(sdkBasePath, sdkElement);
            }
        } else {
            for (ToolChainSdkDescriptor toolChain : toolChains) {
                Element holderElement = toolChain.convertToXml(document, sdkElement);
                if (toolChain.isRootToolChain()) {
                    SymbolSdkDescriptors.convertToXml((String)sdkId, (String)toolChain.getToolChainId(), (Document)document, (Element)sdkElement);
                    ResourceSdkDescriptors.convertToXml((String)sdkId, (String)toolChain.getToolChainId(), (Document)document, (Element)sdkElement);
                }
                SdkDescriptorUtils.relativizeResourcesPath(sdkBasePath, holderElement);
            }
        }
    }

    public static void relativizeResourcesPath(String sdkBaseBath, Element holderElement) throws CoreException {
        Path resolvedBaseBath = Paths.get(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(sdkBaseBath, true), new String[0]).normalize();
        for (ResourceSdkKind kind : ResourceSdkKind.validValues()) {
            NodeList nl = holderElement.getElementsByTagName(kind.getXmlElementName());
            int j = 0;
            while (j < nl.getLength()) {
                Element resourceElement = (Element)nl.item(j);
                Path resourcePath = Paths.get(resourceElement.getAttribute("path").trim(), new String[0]);
                if (resourcePath.isAbsolute()) {
                    String relativePath = resolvedBaseBath.relativize(resourcePath).toString();
                    resourceElement.setAttribute("path", relativePath);
                }
                ++j;
            }
        }
    }
}

