/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkManifestHeaderValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkManifestModuleValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkManifestSymbolValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SdkManifestValidator
implements IValidator<String> {
    private String sdkId;

    public SdkManifestValidator(String sdkId) {
        this.sdkId = sdkId;
    }

    public String getSdkId() {
        return this.sdkId;
    }

    public IStatus validate(String sdkDescriptorXml) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
        String errorMessage = NLS.bind((String)Messages.SdkManifestValidator_manifest_load_error, (Object)this.sdkId);
        Document document = this.convertSdkXmlToDocument(sdkDescriptorXml, errorMessage);
        if (document == null) {
            return ValidationStatus.error((String)errorMessage);
        }
        this.validateSdkHeaders(document, result);
        this.validateSdkModules(document, result);
        this.validateSdkSymbols(document, result);
        return result;
    }

    private Document convertSdkXmlToDocument(String sdkDescriptorXml, String errorMessage) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(sdkDescriptorXml.getBytes("UTF-8")));
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            SdkCoreActivator.getInstance().logError(errorMessage, e);
            return null;
        }
    }

    private void validateSdkHeaders(Document document, MultiStatus result) {
        Element headerElement = this.getElementByTag(document, "sdk");
        if (headerElement != null) {
            result.addAll(new SdkManifestHeaderValidator(this.sdkId).validate(headerElement));
        }
    }

    private void validateSdkModules(Document document, MultiStatus result) {
        Element moduleElement = this.getElementByTag(document, "modules");
        if (moduleElement != null) {
            result.addAll(new SdkManifestModuleValidator(this.sdkId).validate(moduleElement));
        }
    }

    private void validateSdkSymbols(Document document, MultiStatus result) {
        Element symbolElement = this.getElementByTag(document, "symbols");
        if (symbolElement != null) {
            result.addAll(new SdkManifestSymbolValidator().validate(symbolElement));
        }
    }

    private Element getElementByTag(Document document, String tag) {
        NodeList variablesNode = document.getElementsByTagName(tag);
        int i = 0;
        while (i < variablesNode.getLength()) {
            Element element = (Element)variablesNode.item(i);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }
}

