/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.module.ModuleSdkDescriptor;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkModuleValidator
implements IValidator<ModuleSdkDescriptor> {
    public IStatus validate(ModuleSdkDescriptor sdkModule) {
        IStatus validateSdkIdStatus;
        IStatus validateModuleNameStatus;
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
        IStatus validateModuleIdStatus = SdkModuleValidator.validateAttributeNotEmpty(sdkModule.getModuleId(), Messages.SdkModuleValidator_module_id_empty);
        if (!validateModuleIdStatus.isOK()) {
            result.add(validateModuleIdStatus);
        }
        if (!(validateModuleNameStatus = SdkModuleValidator.validateAttributeNotEmpty(sdkModule.getName(), Messages.SdkModuleValidator_module_name_empty)).isOK()) {
            result.add(validateModuleNameStatus);
        }
        if (validateModuleIdStatus.isOK() && !(validateSdkIdStatus = SdkModuleValidator.validateSdkIdAttribute(sdkModule)).isOK()) {
            result.add(validateSdkIdStatus);
        }
        return result;
    }

    private static IStatus validateAttributeNotEmpty(String attributeValue, String errorMessage) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            return ValidationStatus.error((String)errorMessage);
        }
        return Status.OK_STATUS;
    }

    private static IStatus validateSdkIdAttribute(ModuleSdkDescriptor sdkModule) {
        IStatus status = SdkModuleValidator.validateAttributeNotEmpty(sdkModule.getModuleSdkId(), Messages.SdkModuleValidator_module_sdk_id_empty);
        if (status.isOK()) {
            String refferSdkId;
            String holderSdkId = sdkModule.getSdkId();
            if (holderSdkId.equals(refferSdkId = sdkModule.getModuleSdkId())) {
                status = ValidationStatus.error((String)NLS.bind((String)Messages.SdkModuleValidator_module_refers_to_holder_sdk, (Object)sdkModule.getModuleId(), (Object)holderSdkId));
            }
            if (status.isOK() && SdkDescriptors.getSdkDescriptor((String)refferSdkId) == null) {
                status = ValidationStatus.error((String)NLS.bind((String)Messages.SdkModuleValidator_module_sdk_id_not_exist, (Object)sdkModule.getModuleId(), (Object)refferSdkId));
            }
        }
        return status;
    }
}

