/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action;

import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionOperations;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.AbstractSdkAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ProjectOptionAction
extends AbstractSdkAction {
    protected String optionId;
    protected String optionValue;
    protected SdkActionOperations operation;
    private Set<String> relatedConfigurations;

    protected ProjectOptionAction(String optionId, String optionValue, SdkActionOperations operation) {
        this.optionId = Objects.requireNonNull(optionId);
        this.optionValue = optionValue != null ? optionValue : "";
        this.operation = Objects.requireNonNull(operation);
        this.relatedConfigurations = new HashSet<String>();
    }

    protected ProjectOptionAction(String optionId, String optionValue, Set<String> configurationsIds, SdkActionOperations operation) {
        this(optionId, optionValue, operation);
        if (configurationsIds != null && !configurationsIds.isEmpty()) {
            this.relatedConfigurations = configurationsIds.stream().filter(Objects::nonNull).map(String::trim).filter(configurationId -> !configurationId.isEmpty()).collect(Collectors.toSet());
        }
    }

    protected ProjectOptionAction(Element projectOptionActionElement) {
        super(projectOptionActionElement);
        this.optionId = projectOptionActionElement.getAttribute("id");
        this.optionValue = projectOptionActionElement.getAttribute("value");
        this.operation = ProjectOptionAction.getUpdateOperation(projectOptionActionElement);
        this.relatedConfigurations = Arrays.stream(projectOptionActionElement.getAttribute("configId").split(",")).map(String::trim).filter(configurationId -> !configurationId.isEmpty()).collect(Collectors.toSet());
    }

    public String getOptionId() {
        return this.optionId;
    }

    public String getOptionValue() {
        return this.optionValue;
    }

    public Set<String> getRelatedConfigurations() {
        return Collections.unmodifiableSet(this.relatedConfigurations);
    }

    @Override
    public void convertToXml(Document document, Element actionsElement) {
        Element element = this.createElement(document);
        if (element != null) {
            this.convertAttributesToXml(document, element);
            actionsElement.appendChild(element);
        }
    }

    protected abstract Element createElement(Document var1);

    @Override
    public boolean isApplicable(IConfiguration configuration) {
        if (!this.isApplicableForConfiguration(configuration)) {
            return false;
        }
        return super.isApplicable(configuration);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.optionId == null ? 0 : this.optionId.hashCode());
        result = 31 * result + (this.optionValue == null ? 0 : this.optionValue.hashCode());
        result = 31 * result + (this.relatedConfigurations == null ? 0 : this.relatedConfigurations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectOptionAction)) {
            return false;
        }
        ProjectOptionAction other = (ProjectOptionAction)obj;
        if (this.operation != other.operation) {
            return false;
        }
        if (this.optionId == null ? other.optionId != null : !this.optionId.equals(other.optionId)) {
            return false;
        }
        if (this.optionValue == null ? other.optionValue != null : !this.optionValue.equals(other.optionValue)) {
            return false;
        }
        return !(this.relatedConfigurations == null ? other.relatedConfigurations != null : !this.relatedConfigurations.equals(other.relatedConfigurations));
    }

    public boolean isApplicableForConfiguration(IConfiguration configuration) {
        return this.relatedConfigurations == null || this.relatedConfigurations.isEmpty() || configuration == null || this.relatedConfigurations.contains(configuration.getBaseId()) || this.relatedConfigurations.contains(configuration.getName());
    }

    @Override
    protected void convertAttributesToXml(Document document, Element element) {
        super.convertAttributesToXml(document, element);
        element.setAttribute("id", this.optionId);
        element.setAttribute("value", this.optionValue);
        if (!this.relatedConfigurations.isEmpty()) {
            element.setAttribute("configId", String.join((CharSequence)",", this.relatedConfigurations));
        }
    }

    private static SdkActionOperations getUpdateOperation(Element element) {
        switch (element.getNodeName()) {
            case "addOptionValue": {
                return SdkActionOperations.OPTION_VALUE_ADD;
            }
            case "removeOptionValue": {
                return SdkActionOperations.OPTION_VALUE_REMOVE;
            }
            case "setOptionValue": {
                return SdkActionOperations.OPTION_VALUE_SET;
            }
            case "cleanupOptionValue": {
                return SdkActionOperations.OPTION_VALUE_CLEANUP;
            }
            case "checkOptionValue": {
                return SdkActionOperations.OPTION_VALUE_CHECK;
            }
        }
        return null;
    }
}

