/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.AbstractSdkAction;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ProjectResourceAction
extends AbstractSdkAction {
    public static final String PROJECT_RESOURCE_ACTION_PATH_ATTRIBUTE = "path";
    public static final String PROJECT_RESOURCE_ACTION_BUILD_PATH_ATTRIBUTE = "buildPath";
    public static final String PROJECT_RESOURCE_ACTION_BACKUP_ATTRIBUTE = "backup";
    protected static final String PATHS_DELIMITER = ",";
    protected static final String WILDCARD_MASK = "*";
    protected Set<String> paths;
    protected boolean isBackupResource;
    protected boolean isIncludeResourceToBuildPath;

    protected ProjectResourceAction(Element element) {
        super(element);
        this.paths = Arrays.stream(element.getAttribute(PROJECT_RESOURCE_ACTION_PATH_ATTRIBUTE).split(PATHS_DELIMITER)).map(String::trim).filter(this::isPathValid).collect(Collectors.toSet());
        this.isBackupResource = false;
        this.isIncludeResourceToBuildPath = false;
    }

    protected Element getXmlElement(String elementName, Document document) {
        Element element = document.createElement(elementName);
        element.setAttribute(PROJECT_RESOURCE_ACTION_PATH_ATTRIBUTE, this.pathsToString());
        return element;
    }

    protected abstract Collection<IResource> getResources(IProject var1);

    protected IStatus backupResource(IProject project, List<IResource> backedupResources) {
        return Status.CANCEL_STATUS;
    }

    protected IStatus backupResource(IProject project) {
        return Status.CANCEL_STATUS;
    }

    protected abstract String getElementName();

    @Override
    public void convertToXml(Document document, Element actionsElement) {
        Element element = document.createElement(this.getElementName());
        super.convertAttributesToXml(document, element);
        element.setAttribute(PROJECT_RESOURCE_ACTION_PATH_ATTRIBUTE, this.pathsToString());
        if (this.isBackupResource) {
            element.setAttribute(PROJECT_RESOURCE_ACTION_BACKUP_ATTRIBUTE, String.valueOf(Boolean.TRUE));
        }
        if (this.isIncludeResourceToBuildPath) {
            element.setAttribute(PROJECT_RESOURCE_ACTION_BUILD_PATH_ATTRIBUTE, String.valueOf(Boolean.TRUE));
        }
        actionsElement.appendChild(element);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectResourceAction)) {
            return false;
        }
        ProjectResourceAction other = (ProjectResourceAction)obj;
        return !(this.paths == null ? other.paths != null : !this.paths.equals(other.paths));
    }

    protected IStatus includeResourceToBuildPath(IResource resource, IConfiguration configuration) {
        if (resource != null) {
            MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
            String resourcePath = resource.getFullPath().toString();
            ProjectSettingsUpdater sourceEntriesUpdater = ProjectSettingsUpdaters.getSourceEntriesUpdater();
            result.add(sourceEntriesUpdater.update(configuration, null, resourcePath, UpdateOperation.ADD));
            return result;
        }
        return Status.CANCEL_STATUS;
    }

    protected IStatus excludeResourceFromBuildPath(IResource resource, IConfiguration configuration) {
        if (resource != null) {
            MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
            String resourcePath = resource.getFullPath().toString();
            ProjectSettingsUpdater sourceEntriesUpdater = ProjectSettingsUpdaters.getSourceEntriesUpdater();
            result.add(sourceEntriesUpdater.update(configuration, null, resourcePath, UpdateOperation.REMOVE));
            return result;
        }
        return Status.CANCEL_STATUS;
    }

    protected String pathsToString() {
        return String.join((CharSequence)PATHS_DELIMITER, this.paths);
    }

    protected Collection<IResource> collectChildResources(IProject project, String parentPath) {
        final ArrayList<IResource> result = new ArrayList<IResource>();
        final IFolder parentFolder = project.getFolder(parentPath);
        try {
            parentFolder.accept(new IResourceVisitor(){

                public boolean visit(IResource childResource) throws CoreException {
                    if (!childResource.equals((Object)parentFolder)) {
                        result.add(childResource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError("Unable to get resources due to error.", ce);
        }
        return result;
    }

    protected boolean isPathValid(String path) {
        return !path.isEmpty();
    }

    @Override
    public boolean isApplicable(IConfiguration configuration) {
        SdkDescriptor sdkDescriptor = SdkDescriptors.getSdkDescriptor((String)this.sdkId);
        IProject project = configuration.getOwner().getProject();
        if (sdkDescriptor == null || project == null || !project.isAccessible()) {
            return false;
        }
        return super.isApplicable(configuration);
    }
}

