/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionOperations;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceAction;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Element;

public class ProjectResourceBuildPathIncludeAction
extends ProjectResourceAction {
    public static final String INCLUDE_FILE_TO_BUILD_PATH_ACTION_ELEMENT = "includeProjectFileToBuildPath";
    public static final String INCLUDE_FOLDER_TO_BUILD_PATH_ACTION_ELEMENT = "includeProjectFolderToBuildPath";
    private SdkActionOperations operation;

    public ProjectResourceBuildPathIncludeAction(Element element) {
        super(element);
        this.operation = ProjectResourceBuildPathIncludeAction.getOperation(element);
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        this.getResources(project).forEach(res -> result.add(this.includeResourceToBuildPath((IResource)res, configuration)));
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectResourceBuildPathIncludeAction)) {
            return false;
        }
        ProjectResourceBuildPathIncludeAction other = (ProjectResourceBuildPathIncludeAction)obj;
        return this.operation == other.operation;
    }

    @Override
    protected Collection<IResource> getResources(IProject project) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (String pathString : this.paths) {
            IPath path = Path.fromOSString((String)pathString);
            if ("*".equals(path.lastSegment())) {
                String parentPath = path.uptoSegment(path.segmentCount() - 1).toOSString();
                if (parentPath.isEmpty()) continue;
                Collection<IResource> childResources = this.collectChildResources(project, parentPath);
                childResources.forEach(resource -> {
                    boolean bl = result.add((IResource)(1 == resource.getType() ? resource.getParent() : resource));
                });
                continue;
            }
            IResource resource2 = project.findMember(pathString);
            if (resource2 == null) continue;
            result.add((IResource)(1 == resource2.getType() ? resource2.getParent() : resource2));
        }
        return result;
    }

    @Override
    protected String getElementName() {
        switch (this.operation) {
            case PROJECT_FILE_INCLUDE_TO_BUILD_PATH: {
                return INCLUDE_FILE_TO_BUILD_PATH_ACTION_ELEMENT;
            }
            case PROJECT_FOLDER_INCLUDE_TO_BUILD_PATH: {
                return INCLUDE_FOLDER_TO_BUILD_PATH_ACTION_ELEMENT;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static SdkActionOperations getOperation(Element element) {
        switch (element.getNodeName()) {
            case "includeProjectFileToBuildPath": {
                return SdkActionOperations.PROJECT_FILE_INCLUDE_TO_BUILD_PATH;
            }
            case "includeProjectFolderToBuildPath": {
                return SdkActionOperations.PROJECT_FOLDER_INCLUDE_TO_BUILD_PATH;
            }
        }
        return SdkActionOperations.UNSUPPORTED_OPERATION;
    }
}

