/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public abstract class ProjectResourceFileAction
extends ProjectResourceAction {
    public static final String REMOVE_PROJECT_FILE_ELEMENT = "removeProjectFile";
    public static final String BACKUP_PROJECT_FILE_ELEMENT = "backupProjectFile";

    protected ProjectResourceFileAction(Element element) {
        super(element);
    }

    @Override
    protected Collection<IResource> getResources(IProject project) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (String pathString : this.paths) {
            IPath path = Path.fromOSString((String)pathString);
            if ("*".equals(path.lastSegment())) {
                String parentPath = path.uptoSegment(path.segmentCount() - 1).toOSString();
                if (parentPath.isEmpty()) continue;
                this.collectChildResources(project, parentPath).stream().filter(resource -> 1 == resource.getType()).forEach(result::add);
                continue;
            }
            result.add((IResource)project.getFile(pathString));
        }
        return result;
    }

    @Override
    protected IStatus backupResource(IProject project) {
        return this.backupResource(project, null);
    }

    @Override
    protected IStatus backupResource(IProject project, List<IResource> backedupResources) {
        if (backedupResources == null) {
            backedupResources = new ArrayList<IResource>();
        }
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        for (IResource resource : this.getResources(project)) {
            IFile sourceFile = (IFile)resource;
            String backupFilePath = sourceFile.getProjectRelativePath() + ".bak";
            IFile backupFile = project.getFile(backupFilePath);
            if (backupFile == null || backupFile.exists()) {
                result.add((IStatus)new Status(8, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectResourceAction_error_resource_already_exists, (Object)backupFilePath)));
                continue;
            }
            try {
                sourceFile.copy(backupFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
                backedupResources.add((IResource)backupFile);
            }
            catch (CoreException ce) {
                result.add((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectResourceAction_error_execute_backup_exception, (Object)backupFilePath), (Throwable)ce));
            }
        }
        return result;
    }

    @Override
    protected IStatus includeResourceToBuildPath(IResource resource, IConfiguration configuration) {
        return Status.CANCEL_STATUS;
    }
}

