/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderAction;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class ProjectResourceFolderCleanupAction
extends ProjectResourceFolderAction {
    public ProjectResourceFolderCleanupAction(Element element) {
        super(element);
        this.isBackupResource = Boolean.parseBoolean(element.getAttribute("backup"));
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        if (!project.isAccessible()) {
            return new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectFolderCleanupAction_error_project_not_accessible, (Object)this.pathsToString(), (Object)project));
        }
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        for (IResource resource : this.getResources(project)) {
            final IFolder folder = (IFolder)resource;
            if (!folder.exists()) {
                result.add((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectFolderCleanupAction_error_folder_not_exists, (Object)folder.getProjectRelativePath().toOSString())));
            }
            if (this.isBackupResource) {
                this.backupResource(project);
            }
            try {
                folder.accept(new IResourceVisitor(){

                    public boolean visit(IResource childResource) throws CoreException {
                        if (!childResource.equals((Object)folder)) {
                            childResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        return true;
                    }
                });
            }
            catch (CoreException ce) {
                result.add((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectFolderCleanupAction_error_execute_exception, (Object)this.pathsToString()), (Throwable)ce));
            }
        }
        return result;
    }

    @Override
    protected String getElementName() {
        return "cleanupProjectFolder";
    }
}

