/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.filtering;

import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class SdkFilteringUtils {
    private static final String EP_HARDWARE = "com.freescale.s32ds.cross.core.Hardware";
    private static final String ELEMENT_HARDWARE = "hardware";
    private static final String ELEMENT_PROCESSORS = "processors";
    private static final String ELEMENT_PROCESSOR = "processor";
    private static final String ELEMENT_CORE_TYPES = "coreTypes";
    private static final String ELEMENT_CORE_TYPE = "coreType";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CORE_KIND_ID = "coreKindId";
    private static Map<String, String> coreKindsMap = SdkFilteringUtils.loadCoreKindsMap();

    private SdkFilteringUtils() {
    }

    public static String getCoreKind(String deviceCoreId) {
        String coreKind = coreKindsMap.get(deviceCoreId);
        return coreKind != null ? coreKind : deviceCoreId;
    }

    public static String unifyProcessor(String id) {
        return id.toUpperCase().replace("SKEAZ", "KEAZ");
    }

    public static String unifyCoreKind(String id) {
        id = id.replace("+", "plus");
        return SdkFilteringUtils.getCoreKind(id);
    }

    public static boolean isSdkAcceptsProjectComponentHardwareIds(String sdkId, String projectDeviceId, String projectDeviceCoreId, String projectCoreId, String projectDeviceRevisionId) {
        Set<String> projectDeviceIds = projectDeviceId != null && !projectDeviceId.isEmpty() ? Collections.singleton(projectDeviceId) : Collections.emptySet();
        Set<String> projectDeviceCoreIds = projectDeviceCoreId != null && !projectDeviceCoreId.isEmpty() ? Collections.singleton(projectDeviceCoreId) : Collections.emptySet();
        Set<String> projectCoreIds = projectCoreId != null && !projectCoreId.isEmpty() ? Collections.singleton(projectCoreId) : Collections.emptySet();
        Set<String> projectDeviceRevisionIds = projectDeviceRevisionId != null && !projectDeviceRevisionId.trim().isEmpty() ? Collections.singleton(projectDeviceRevisionId) : Collections.emptySet();
        return SdkFilteringUtils.isSdkAcceptsProjectComponentHardwareIds(sdkId, projectDeviceIds, projectDeviceCoreIds, projectCoreIds, projectDeviceRevisionIds);
    }

    public static boolean isSdkAcceptsProjectComponentHardwareIds(String sdkId, Set<String> projectDeviceIds, Set<String> projectDeviceCoreIds, Set<String> projectCoreIds, Set<String> projectDeviceRevisionIds) {
        boolean result;
        Map hardwareSdkDescriptorsIds = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)sdkId);
        Set sdkDeviceIdList = (Set)hardwareSdkDescriptorsIds.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        Set sdkDeviceCoreIdList = (Set)hardwareSdkDescriptorsIds.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        Set sdkCoreIdList = (Set)hardwareSdkDescriptorsIds.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        Set sdkDeviceRevisionIdList = (Set)hardwareSdkDescriptorsIds.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
        sdkDeviceRevisionIdList.removeIf(String::isEmpty);
        if (sdkDeviceIdList.isEmpty() && sdkDeviceCoreIdList.isEmpty() && sdkCoreIdList.isEmpty()) {
            return true;
        }
        if (projectDeviceIds.isEmpty() && projectDeviceCoreIds.isEmpty() && projectCoreIds.isEmpty()) {
            return false;
        }
        boolean isAccepted = true;
        boolean hasIds = false;
        if (!projectDeviceCoreIds.isEmpty() && !sdkDeviceCoreIdList.isEmpty()) {
            isAccepted = sdkDeviceCoreIdList.stream().map(DeviceDescriptors::getDeviceCoreDescriptor).filter(Objects::nonNull).map(EntityDescriptor::getId).anyMatch(projectDeviceCoreIds::contains);
            hasIds = true;
        }
        if (isAccepted && !projectDeviceIds.isEmpty() && !sdkDeviceIdList.isEmpty()) {
            isAccepted = sdkDeviceIdList.stream().map(DeviceDescriptors::getDeviceDescriptor).filter(Objects::nonNull).map(EntityDescriptor::getId).anyMatch(projectDeviceIds::contains);
            hasIds = true;
        }
        if (isAccepted && !projectCoreIds.isEmpty() && !sdkCoreIdList.isEmpty()) {
            isAccepted = projectCoreIds.stream().anyMatch(sdkCoreIdList::contains);
            hasIds = true;
        }
        if (isAccepted) {
            isAccepted = SdkFilteringUtils.isSdkAcceptsProjectDeviceRevisionId(projectDeviceRevisionIds, sdkDeviceRevisionIdList);
        }
        boolean bl = result = hasIds ? isAccepted : false;
        return result;
    }

    private static boolean isSdkAcceptsProjectDeviceRevisionId(Set<String> projectDeviceRevisionIds, Set<String> sdkDeviceRevisionIds) {
        block2: {
            block3: {
                if (projectDeviceRevisionIds.isEmpty()) break block2;
                if (projectDeviceRevisionIds.isEmpty() || sdkDeviceRevisionIds.isEmpty()) break block3;
                if (projectDeviceRevisionIds.stream().anyMatch(sdkDeviceRevisionIds::contains)) break block2;
            }
            return false;
        }
        return true;
    }

    private static Map<String, String> loadCoreKindsMap() {
        HashMap<String, String> coreKinds = new HashMap<String, String>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(EP_HARDWARE);
        if (ep == null) {
            return new HashMap<String, String>();
        }
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement celk = iConfigurationElementArray[n4];
                if (ELEMENT_HARDWARE.equals(celk.getName())) {
                    IConfigurationElement[] iConfigurationElementArray2 = celk.getChildren(ELEMENT_PROCESSORS);
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement processorsElement = iConfigurationElementArray2[n6];
                        IConfigurationElement[] iConfigurationElementArray3 = processorsElement.getChildren(ELEMENT_PROCESSOR);
                        int n7 = iConfigurationElementArray3.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            IConfigurationElement processorElement = iConfigurationElementArray3[n8];
                            IConfigurationElement[] iConfigurationElementArray4 = processorElement.getChildren(ELEMENT_CORE_TYPES);
                            int n9 = iConfigurationElementArray4.length;
                            int n10 = 0;
                            while (n10 < n9) {
                                IConfigurationElement coreTypesElement = iConfigurationElementArray4[n10];
                                IConfigurationElement[] iConfigurationElementArray5 = coreTypesElement.getChildren(ELEMENT_CORE_TYPE);
                                int n11 = iConfigurationElementArray5.length;
                                int n12 = 0;
                                while (n12 < n11) {
                                    IConfigurationElement coreTypeElement = iConfigurationElementArray5[n12];
                                    coreKinds.put(coreTypeElement.getAttribute(ATTRIBUTE_ID), coreTypeElement.getAttribute(ATTRIBUTE_CORE_KIND_ID));
                                    ++n12;
                                }
                                ++n10;
                            }
                            ++n8;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        SdkFilteringUtils.addLegacySDKs(coreKinds);
        return coreKinds;
    }

    private static void addLegacySDKs(Map<String, String> coreKinds) {
        coreKinds.put("M0plus", "cortex-m0plus");
        coreKinds.put("S32V_M0plus", "cortex-m0plus");
        coreKinds.put("M4", "cortex-m4");
        coreKinds.put("A5", "cortex-a5");
    }
}

