/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.parsers.AbstractResourceTagsConverter;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkAction;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import org.w3c.dom.Element;

class MultipleResourceTagsConverter
extends AbstractResourceTagsConverter {
    protected MultipleResourceTagsConverter(Element resourceElement, String sdkBasePath) {
        super(resourceElement, sdkBasePath);
    }

    @Override
    protected Collection<Element> convertInternally() {
        return this.createResourceElements();
    }

    @Override
    protected void adjustFileElementCopyAttributes(Element fileElement, Element folderElement) {
        if (ResourceSdkAction.of((String)this.resourceElement.getNodeName()).isFileAction()) {
            return;
        }
        fileElement.setAttribute("copy", Boolean.TRUE.toString());
        String folderCopyToPath = MultipleResourceTagsConverter.getResourceCopyPath(folderElement);
        Path filePathParent = Paths.get(MultipleResourceTagsConverter.getResourcePath(fileElement), new String[0]).getParent();
        Path folderPath = Paths.get(MultipleResourceTagsConverter.getResourcePath(folderElement), new String[0]);
        fileElement.setAttribute("copyToProjectPath", Paths.get(folderCopyToPath, folderPath.getName(0).relativize(filePathParent).toString()).toString());
    }

    @Override
    protected AbstractResourceTagsConverter.FileVisitor getFileVisitor(Path fromPath, PathMatcher pathMatcher) {
        return new AbstractResourceTagsConverter.FileVisitor(fromPath, pathMatcher){

            @Override
            protected FileVisitResult handleVisitFile(Path startPath, Path path, PathMatcher pathMatcher, Collection<Path> resourcesPaths) {
                if (!this.isStartPath(path.getParent())) {
                    resourcesPaths.add(path);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            protected FileVisitResult handlePreVisitDirectory(Path startPath, Path path, PathMatcher pathMatcher, Collection<Path> resourcesPaths) {
                if (this.isStartPath(path)) {
                    return FileVisitResult.CONTINUE;
                }
                if (this.isStartPath(path.getParent()) && !pathMatcher.matches(path)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }
}

